(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   4900527,      85970]
NotebookOptionsPosition[   4893408,      85865]
NotebookOutlinePosition[   4893842,      85882]
CellTagsIndexPosition[   4893799,      85879]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Sample playground", "Title",
 CellChangeTimes->{{3.8601397412505856`*^9, 
  3.860139755017807*^9}},ExpressionUUID->"d0e8ddea-97d3-4359-93ee-\
9734776dce2c"],

Cell[TextData[{
 "This notebook is used for the processing and fitting of one sample. It \
requires the functions in ",
 StyleBox["Polydisp fitting functions all data.nb",
  FontSlant->"Italic"],
 ".\nIntensity units are arbitrary as the patterns are rescaled for merging."
}], "Text",
 CellChangeTimes->{{3.8601397453382463`*^9, 3.8601397964528313`*^9}, {
  3.8617669288125243`*^9, 3.861766945139561*^9}, {3.8617673062268524`*^9, 
  3.8617673066939745`*^9}, {3.861942912912383*^9, 
  3.861942913146066*^9}},ExpressionUUID->"7c1a7862-4493-4bbd-ad86-\
2d905071e2e2"],

Cell[CellGroupData[{

Cell["Select and plot the data to be analyzed", "Subsubsection",
 CellChangeTimes->{{3.854421099868669*^9, 3.854421101948415*^9}, {
  3.8601398442554398`*^9, 
  3.8601398549474306`*^9}},ExpressionUUID->"44c23e06-c6ba-4d87-ae3e-\
52595994b93e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Join", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Keys", "[", "sampleFiles", "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"s", ",", "\"\<C20_*\>\""}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Keys", "[", "sampleFiles", "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"s", ",", "\"\<BG25_*\>\""}], "]"}]}]}], "]"}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"testsamples", "=", "%"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"testsamples", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<171_1.4002\>\"", ",", "\"\<171_30.9999\>\"", ",", 
       "\"\<171_9.99982\>\"", ",", "\"\<171_9.99999\>\""}], "}"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.843296948142498*^9, 3.843296958212912*^9}, {
   3.8432972784145517`*^9, 3.8432973057271643`*^9}, {3.8432977131560783`*^9, 
   3.843297716018899*^9}, {3.843298309901671*^9, 3.84329834918407*^9}, 
   3.843298997733918*^9, {3.8432990321174*^9, 3.843299072004407*^9}, {
   3.843299122424327*^9, 3.843299133661518*^9}, {3.843299265884342*^9, 
   3.84329926858108*^9}, {3.843300103749148*^9, 3.843300112466827*^9}, {
   3.8527849855621357`*^9, 3.852784994200242*^9}, {3.852787417047249*^9, 
   3.852787424091958*^9}, {3.8527874789702*^9, 3.8527874801375923`*^9}, {
   3.852787728214538*^9, 3.852787778738393*^9}, {3.8527968489630823`*^9, 
   3.8527968515622187`*^9}, {3.8527969362639837`*^9, 3.852796936383173*^9}, {
   3.8527970088774014`*^9, 3.8527970089163847`*^9}, {3.853836617160633*^9, 
   3.853836617592147*^9}, {3.854421141973649*^9, 3.854421142035899*^9}, {
   3.8544211928939333`*^9, 3.854421193010366*^9}, {3.860120705408345*^9, 
   3.860120705446088*^9}, {3.8617632879814606`*^9, 3.861763304765732*^9}, {
   3.8617673092767124`*^9, 3.8617673185406885`*^9}, {3.8859734491964083`*^9, 
   3.885973455500765*^9}, {3.8859747794365234`*^9, 3.8859748137649736`*^9}, {
   3.8859750181935196`*^9, 3.885975018432844*^9}, {3.8859763176629515`*^9, 
   3.8859763198468237`*^9}, {3.8859770271978893`*^9, 
   3.8859770297569485`*^9}, {3.8859774963407874`*^9, 3.885977500029621*^9}, {
   3.8859790256696296`*^9, 3.8859790880678005`*^9}, {3.8859792862203617`*^9, 
   3.885979303353922*^9}, {3.885979636059869*^9, 3.885979636325242*^9}, {
   3.8859798673963566`*^9, 3.885979867979951*^9}, {3.8859802087472224`*^9, 
   3.8859802091063414`*^9}, 3.8859802670443172`*^9, {3.8859805336112413`*^9, 
   3.8859805370509305`*^9}, {3.885980676883481*^9, 3.8859806770585265`*^9}, {
   3.8860615694895253`*^9, 3.8860615965610476`*^9}, {3.8902035063775234`*^9, 
   3.8902035070815973`*^9}, {3.8914972133528996`*^9, 3.8914972138838634`*^9}},
 CellLabel->
  "In[1175]:=",ExpressionUUID->"288b6ba3-0e36-41d8-949e-a2c664f880eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C20_30.7138\"\>", ",", "\<\"C20_10.0042\"\>", 
   ",", "\<\"C20_1.504\"\>", ",", "\<\"BG25_30.7138\"\>", 
   ",", "\<\"BG25_10.0042\"\>", ",", "\<\"BG25_1.504\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.85278774182577*^9, 3.8527877823161783`*^9}, 
   3.852796852362589*^9, 3.852796937189692*^9, 3.852797010008708*^9, 
   3.8528624946560097`*^9, 3.853381366643115*^9, 3.853381473062273*^9, 
   3.8534022376061707`*^9, 3.85346909236896*^9, 3.8534962759553757`*^9, 
   3.8534996218158073`*^9, 3.853817842919454*^9, 3.853818242802884*^9, 
   3.853824682294836*^9, 3.853824869851644*^9, 3.853833074084684*^9, 
   3.853836452539434*^9, 3.8538366226871643`*^9, 3.8538385385329847`*^9, 
   3.854072553810278*^9, 3.85409167434895*^9, 3.854098459654634*^9, 
   3.854420757546021*^9, 3.854421148417843*^9, 3.8544211935109262`*^9, 
   3.8544236425084476`*^9, 3.860120714271991*^9, {3.8601208146323557`*^9, 
   3.860120817823097*^9}, 3.8601209904370317`*^9, {3.8601401966367846`*^9, 
   3.8601402016808*^9}, {3.8601411929801598`*^9, 3.860141197066132*^9}, 
   3.8617633119613857`*^9, 3.8617673196071157`*^9, 3.861941017862147*^9, 
   3.8619433170388165`*^9, 3.861950007077615*^9, 3.861950097594084*^9, 
   3.861950313053934*^9, 3.8859734561647086`*^9, 3.8859735723144336`*^9, {
   3.8859747343360167`*^9, 3.8859747430702314`*^9}, 3.8859747970713787`*^9, 
   3.8859750198706293`*^9, 3.885976323503401*^9, 3.8859770304553003`*^9, 
   3.885977536755321*^9, {3.885979057328891*^9, 3.885979092434539*^9}, {
   3.8859792905705223`*^9, 3.885979306593282*^9}, 3.8859796400840683`*^9, 
   3.885979871667265*^9, 3.8859802113912177`*^9, 3.8859802706713324`*^9, 
   3.885980540538966*^9, 3.8859806802452884`*^9, 3.886061601230296*^9, 
   3.8861522211573744`*^9, 3.8883109765610237`*^9, 3.8890022652170677`*^9, 
   3.8890603226490602`*^9, 3.88906456673145*^9, 3.889081912662714*^9, 
   3.88908274923429*^9, 3.889084479032218*^9, {3.8895035587135143`*^9, 
   3.8895035763897266`*^9}, 3.8895042359682283`*^9, 3.889668723612721*^9, 
   3.890203509837488*^9, 3.89020358352724*^9, 3.8909804837292213`*^9, 
   3.89098153769302*^9, 3.890982738443742*^9, 3.8914160072605443`*^9, 
   3.8914972154035673`*^9, 3.8914975432719035`*^9, 3.891498587225662*^9, 
   3.892613775368435*^9, 3.8926144482288322`*^9, 3.892695999633297*^9, 
   3.9020371032316065`*^9, 3.9020419939951*^9, 3.902293358308179*^9, 
   3.9022934769339275`*^9, 3.902296666667019*^9, 3.9022975254696093`*^9, 
   3.9022975853820953`*^9, 3.9022983612995796`*^9},
 CellLabel->
  "Out[1175]=",ExpressionUUID->"878a81fc-b15b-404a-b9bf-bda5a6e7bbd9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataToPlot", "=", 
   RowBox[{"scatteringDataSampleAveraged", "/@", "testsamples"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"plotDataRaw", " ", "=", " ", 
  RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
   RowBox[{"dataToPlot", ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", "testsamples"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"5", " ", 
          RowBox[{"10", "^", 
           RowBox[{"-", "3"}]}]}], ",", 
         RowBox[{"10", "^", "5"}]}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.01", ",", " ", "0.1", ",", " ", "1"}], "}"}], ",", 
        RowBox[{"{", "Automatic", "}"}], ",", " ", "None", ",", " ", "None"}],
        "}"}], ",", " ", 
      RowBox[{"FrameTicks", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
        "LogTicks", ",", "LinTicks", ",", " ", "None", ",", " ", "None"}], 
        "}"}]}]}], " ", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<DataRaw.pdf\>\""}], "}"}], "]"}], ",", "plotDataRaw"}], " ", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.84329809635746*^9, 3.843298105573452*^9}, {
   3.84329815837682*^9, 3.843298163080853*^9}, {3.843298211914578*^9, 
   3.8432982378108053`*^9}, {3.843298288845417*^9, 3.843298291452414*^9}, 
   3.843298361191868*^9, {3.84329871517915*^9, 3.843298719649724*^9}, {
   3.843299850907208*^9, 3.843299962957724*^9}, {3.843300008752656*^9, 
   3.8433000099440603`*^9}, {3.8433000666678867`*^9, 3.843300081842258*^9}, 
   3.8433001270605783`*^9, 3.852785029476323*^9, {3.8527875156086903`*^9, 
   3.852787529623748*^9}, {3.852787908039447*^9, 3.852787908637274*^9}, {
   3.88951548143122*^9, 3.88951548156557*^9}, {3.8896687353498526`*^9, 
   3.8896687417207317`*^9}, {3.8896725688232393`*^9, 3.889672590126113*^9}, {
   3.889672623190502*^9, 3.8896726983115826`*^9}, {3.889672740640524*^9, 
   3.889672758876796*^9}, {3.8896729834503565`*^9, 3.889673069010479*^9}, {
   3.889673142722207*^9, 3.8896731964734883`*^9}, {3.889676349237294*^9, 
   3.8896763709122796`*^9}, {3.889692253576544*^9, 3.889692254563936*^9}},
 CellLabel->
  "In[1177]:=",ExpressionUUID->"6ebf2b6c-fd73-4115-90fc-264fde664a3f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c81e8Xv/tee4/slkSioTLyfChkhFJGRiGlIVoaKJVUGhoqLVK+VoSI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         "]], 
        LineBox[{{-1.3931625929004259`, -4.229580759688341}, \
{-1.3925541015537621`, -2.0002835618463357`}, {-1.3920855812086557`, \
-5.298317366548036}}], 
        LineBox[{{-1.3917539541465347`, -5.298317366548036}, \
{-1.391338288426397, -3.1727398051829003`}, {-1.3907309656742075`, \
-1.563241442028519}, {-1.3901239517057393`, -2.436470321312072}, \
{-1.3895173657767712`, -3.86078821997029}, {-1.3889110878104278`, \
-1.9596510743801254`}, {-1.3883052369189728`, -2.720477793466163}, \
{-1.387699693172116, -1.040429577206076}, {-1.3870945755389497`, \
-1.4173864775392462`}, {-1.3864897642354097`, -3.5087288280083375`}, \
{-1.3858853185074895`, -2.1390829170829595`}, {-1.3852813570020988`, \
-1.9367416656995762`}, {-1.3846776410293211`, -2.886033773803374}, \
{-1.3840742893096247`, -1.3216459876436764`}, {-1.3834713014037296`, \
-2.718144436687044}, {-1.3828845460182924`, -5.298317366548036}}], 
        LineBox[{{-1.3828586966748972`, -5.298317366548036}, \
{-1.382266534010283, -1.2372105211621878`}, {-1.3816646348465984`, \
-1.1634893092755083`}, {-1.3812454202208129`, -5.298317366548036}}]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3k81O8TX8uyzl0UFZIcUXIUSaXd0OXKEbkLFSmkEhXKUUSHUKikRBRS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         "]], 
        LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAApviQx8Sx0b9TnJQbejEVwBrMGQyp
qNG/FkI00ZXjEsDqpR8qpp7Rv22A0wqSHhLAFhCShKSU0b+ylENME3gRwA6t
SW+kitG/SiZ81gFoEsCXsOo9poDRv8qRzlpk/BHAHMSoR6l20b+jB8y2XbER
wJG0NeCtbNG/+v/864IDEsAUEQ9btGLRv02esmS/QhTAq+W3D7xY0b+uUTmb
5vgSwIBNu1HFTtG/AQMvlmPUEcB3VnB00ETRv25G4NvqNxPAciSpz9w60b9e
eYa+s4sSwFNEyrbqMNG/uygGTU6LEsD+ZQR9+ibRv4ACvcXBExLA4Xp4egsd
0b+0WG3YBToUwOKkZAIeE9G/d7uKSwgAFMDzWNNnMgnRvw/bdOUyBxPAIgw0
A0j/0L8gIAAnuNsSwHqYnidf9dC/cg5Sn1UzE8DWWvcneOvQvxuwWNr7/hPA
YQL8XJLh0L9AebvcpAASwDxEnhmu19C/+HYrkwhdEcB7RXTGndHQv1OclBt6
MRXAvu7EJg==
         "]], 
        LineBox[{{-0.26187256568465767`, -5.298317366548036}, \
{-0.26135511287304525`, -3.995464594866934}, {-0.26075290609440566`, \
-4.161863033962256}, {-0.26015098443578805`, -4.935728272153393}, \
{-0.2595494248689136, -3.0592618395940683`}, {-0.25894830418020226`, \
-4.425787799157939}}]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwcmnc81f8Xx+097xVC04yIlAgd+dLSsEpCRqFQUkokIU0JISPJiBCSTfT5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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c8lf8Xv3svW1RERkhIZd9LZSYkZURJSkmkIqlERltJKErFFylFiSie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         "]], 
        LineBox[CompressedData["
1:eJw9VXs81HkXJol1mfn9ZohqSYnaVjFha9uwNC7pjVxKF0XETrFZUVFEW2Fd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         "]], 
        LineBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAA1e6lA9s+L9TnJQbejEVwP7vBVJt
afi/KwexYvqTEMBuhDfZlGb4v4G41IfQEhHANWY/9Lxj+L+sTbaTXd0TwCiY
L37lYPi/6QwJmIU6EcDHspObDl74v9Oj2P5p8Q7AF/WKJzhb+L8tWq4rcxIR
wK8hlEZiWPi/VLcPJobEEMBCqtvTjFX4v/kp0z8iGhLAcYTT87dS+L9ro26C
/n4QwCJLtYHjT/i/xdbTyN3dDcDwL+ahD034v/XH368rDhDAgu2sLzxK+L9s
8ilfsAoTwE36YU9pR/i/kG1RpE0FFcBXJ1nclkT4v47sEZ/pjRLAyDje+sRB
+L/tYxK54HkQwKgMUobzPvi/orxxmXVxEcCjvfOiIjz4v/dhaL/Fuw/Aci0x
LFI5+L8dJs2vqwYOwAvWPEaCNvi/yn5AxbdUDsCRk5HMsjP4v9Ah3vg3ShHA
BEhV4+Mw+L8BEwbWHIATwK/AD2YVLvi/NlmOEQlEE8BVUNp4Ryv4vwJeC/x4
sxHAN6xJ93ko+L9O+LCJR7QQwIGgagWtJfi/lFwCVvRFEsBEwd5+4CL4v99e
iR6cixHAulymhxQg+L84SH4K5x0RwKDcb/tIHfi/ggzFBxPVD8DaGS/+fRr4
v7E38w/zPBDAvEqfa7MX+L9MRfarZx0VwGTbp2fpFPi/W0ml1bVpFMCvxRDO
HxL4v7pfJnm8MRHAS515al4P+L9TnJQbejEVwMkMGbo=
         "]], 
        LineBox[{{-1.5037373115477313`, -5.298317366548036}, \
{-1.5030652337220112`, -4.331103292784053}, {-1.5023861452440905`, \
-5.176982644281236}, {-1.5017074507178931`, -5.233671505510157}, \
{-1.501029283356703, -4.187777142744001}, {-1.500351508788963, \
-5.122999128780635}, {-1.49967426004908, -3.9248989701165513`}, \
{-1.4989974029491981`, -4.94981402959598}, {-1.4983210703453254`, \
-3.970192279352568}, {-1.4976451282328034`, -4.509504977213211}, \
{-1.497282419903845, -5.298317366548036}}], 
        LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAApneL4K/y979TnJQbejEVwHlwp7DS
8Pe/oCqk+TMhD8Dl+dtqD+73v0LfRKfBaxDAq/xFjUzr97+wKLB5IB4QwCSv
ajuK6Pe/iztDK8POEMAu5nZRyOX3v6NI1Xw7PxTA/88W4Qbj97/taga8RD0U
wBZq6vtF4Pe/1HrsTwxPE8DKMzF+hd33v3fKU7yUUg7A2R9Si8Xa97/4atrb
9LMPwFwUmf8F2Pe/arFhx2pfFMBr92D+RtX3v0BwMCS87hTAPA0CZIjS979q
SzeSOZEPwGg3y1PKz/e/hxvGkWfoDMCsDyGqDM33v8dW61hyCRXAQHtGik/K
978Vo+tpvI0RwNlgrNCSx/e/Z/RZdD4eEcBksYmg1sT3v6Zq+TaG0w3ACJhb
1hrC97/p9UiKYJYQwO8768mUwPe/U5yUG3oxFcBLt7NN
         "]], 
        LineBox[{{-1.483886653499008, -5.298317366548036}, \
{-1.4835555326370005`, -4.39705131516282}, {-1.4828895602005607`, \
-4.401750227067394}, {-1.482223965382512, -4.374087933670677}, \
{-1.4815588788483816`, -3.9384168175040464`}, {-1.4812637138944458`, \
-5.298317366548036}}], 
        LineBox[{{-1.4803310403373955`, -5.298317366548036}, \
{-1.4802299658562001`, -4.992724114168252}, {-1.480130607317852, \
-5.298317366548036}}], 
        LineBox[{{-1.4790167876091118`, -5.298317366548036}, \
{-1.4789028165302598`, -4.938134008965426}, {-1.478239869107999, \
-5.0622434804610075`}, {-1.4775774261954666`, -3.3915402251370703`}, \
{-1.4769153565646709`, -4.558825204390678}, {-1.4762537901952915`, \
-5.058448137319012}, {-1.4755925960345126`, -4.0385819735202935`}, \
{-1.4749775546448352`, -5.298317366548036}}], 
        LineBox[{{-1.4746371640347773`, -5.298317366548036}, \
{-1.4742715828886581`, -5.1823414383079065`}, {-1.4736117626649108`, \
-4.982317778518238}, {-1.4729523125165611`, -3.931031150665172}, \
{-1.4722933619135883`, -3.726149987245192}, {-1.4716347803258993`, \
-3.82044712941299}, {-1.4709766970544564`, -4.794451356971668}, \
{-1.470569512613433, -5.298317366548036}}], 
        LineBox[{{-1.4699900741939378`, -5.298317366548036}, \
{-1.4696617635223481`, -4.988863228633127}, {-1.4690049122101352`, \
-4.9862082416072315`}, {-1.4683990314453386`, -5.298317366548036}}], 
        LineBox[{{-1.4683340010489607`, -5.298317366548036}, \
{-1.467692567190646, -4.152511638544663}, {-1.467037072268365, \
-4.16446176460503}, {-1.4663819421636302`, -4.217548623597961}, \
{-1.4657273055057047`, -4.7324541834001455`}, {-1.465073032626457, \
-3.4151974642051353`}, {-1.4647478434084786`, -5.298317366548036}}], 
        LineBox[{{-1.4639294832167207`, -5.298317366548036}, \
{-1.4637658340941535`, -4.6625171875140605`}, {-1.4635861917095527`, \
-5.298317366548036}}], 
        LineBox[{{-1.4626413805310627`, -5.298317366548036}, \
{-1.4624603420993125`, -4.655187661493137}, {-1.4622737460920365`, \
-5.298317366548036}}], 
        LineBox[{{-1.4603921544184328`, -5.298317366548036}, \
{-1.4598544599396643`, -3.3016071198731365`}, {-1.459204016997299, \
-4.681394983523469}, {-1.458630550877732, -5.298317366548036}}], 
        LineBox[{{-1.4573737786764684`, -5.298317366548036}, \
{-1.4572553507560915`, -4.6081576337074575`}, {-1.4570061472398073`, \
-5.298317366548036}}], 
        LineBox[{{-1.4562430340056267`, -5.298317366548036}, \
{-1.455958325045854, -4.431771799698098}, {-1.4553104105673174`, \
-3.6884219517704806`}, {-1.4546629794324164`, -3.7875887872405443`}, \
{-1.454015903412415, -4.424856977366221}, {-1.4533693095687956`, \
-4.779929861161433}, {-1.4527230698400555`, -4.210198452513272}, \
{-1.4520773111248584`, -4.726138237648436}, {-1.4514319055284977`, \
-3.809659189144794}, {-1.4507869797872333`, -3.6576939636188914`}}], 
        LineBox[{{-1.4494595020042143`, -5.298317366548036}, \
{-1.4488545674843287`, -4.88190758788891}, {-1.4482113012607243`, \
-4.991634932671452}, {-1.4475683851914845`, -4.404280576219742}, \
{-1.446925945528132, -5.058222512174203}, {-1.4465574513315533`, \
-5.298317366548036}}], 
        LineBox[{{-1.4462147731221693`, -5.298317366548036}, \
{-1.445642239814265, -3.820915009826304}, {-1.4450009727872855`, \
-4.487892130493094}, {-1.4443601798882761`, -3.689620948818113}, \
{-1.4437197342142167`, -4.1859897494254525`}, {-1.4430797615355704`, \
-4.521661853962425}, {-1.4424401351130984`, -3.4512697536520935`}, \
{-1.4418009805577212`, -4.25023259330421}, {-1.4416042175553077`, \
-5.298317366548036}}], 
        LineBox[{{-1.4406928177346845`, -5.298317366548036}, \
{-1.4405238327723882`, -4.450565730070384}, {-1.4401712215799982`, \
-5.298317366548036}}], 
        LineBox[{{-1.4396163915314673`, -5.298317366548036}, \
{-1.4392483140132346`, -4.3610435177695415`}, {-1.438611132817861, \
-4.873463190028933}, {-1.4379744201298463`, -3.9908319487200803`}, \
{-1.437387973634555, -5.298317366548036}}], 
        LineBox[{{-1.4347967358750486`, -4.651005338914097}, \
{-1.434162446467272, -5.125227008565867}}], 
        LineBox[{{-1.4328950108984277`, -4.356067813256831}, \
{-1.4322618637985587`, -4.393001183791281}, {-1.4316291796892966`, \
-4.893982783803193}, {-1.4313152749202462`, -5.298317366548036}}], 
        LineBox[{{-1.429102314139286, -3.7975380561614918`}, \
{-1.428471563070626, -3.5806928834518836`}, {-1.428054099927964, \
-5.298317366548036}}], 
        LineBox[{{-1.427063380108268, -5.298317366548036}, \
{-1.4265817554936695`, -3.3967932259575795`}, {-1.42595265378466, \
-5.001251158093977}, {-1.4253238856188197`, -3.9803091493548735`}, \
{-1.424695574492021, -2.7125261171725916`}, {-1.4240675959930522`, \
-4.565336714721569}, {-1.423440073463934, -3.5096303820731847`}, \
{-1.4230640573350464`, -5.298317366548036}}], 
        LineBox[{{-1.4205899318224064`, -5.298317366548036}, \
{-1.4203081690295074`, -3.935636994726556}, {-1.4196830004606906`, \
-3.9113641821774228`}, {-1.4193428567564446`, -5.298317366548036}}], 
        LineBox[{{-1.4178097133274605`, -4.0750369361463985`}, \
{-1.4171861042786886`, -3.1460246966053}, {-1.4165628224394424`, \
-3.514548710088936}, {-1.4159399902365912`, -3.9104830761884}, \
{-1.4153650725124158`, -5.298317366548036}}], 
        LineBox[{{-1.4143543716746851`, -5.298317366548036}, \
{-1.414073695203434, -3.778047679104936}, {-1.4137264541023669`, \
-5.298317366548036}}], 
        LineBox[{{-1.4096183420134631`, -5.298317366548036}, \
{-1.4091139512378517`, -3.6865429357371795`}, {-1.408759986598989, \
-5.298317366548036}}], 
        LineBox[{{-1.4082412080315263`, -5.298317366548036}, \
{-1.407877849340566, -3.580615504897623}, {-1.40746819022165, \
-5.298317366548036}}], 
        LineBox[{{-1.4070536129033233`, -5.298317366548036}, \
{-1.406643273505007, -3.569438934928174}, {-1.4060265870799868`, \
-3.9277720571367136`}, {-1.4054102199677423`, -4.234246477078686}}], 
        LineBox[{{-1.403562249878592, -5.298317366548036}, \
{-1.4029486648038185`, -3.50232074803919}, {-1.4027706951203969`, \
-5.298317366548036}}], 
        LineBox[{{-1.400840577054237, -5.298317366548036}, \
{-1.4004931540181937`, -3.1121560601199656`}, {-1.3998802474910017`, \
-3.325239376225763}}], 
        LineBox[{{-1.398655499903949, -4.120282342546367}, \
{-1.398043657999477, -3.557972110479627}}], 
        LineBox[{{-1.3931625929004259`, -5.250416840132505}, \
{-1.3925541015537621`, -2.861298478622127}, {-1.3919460401861279`, \
-3.31801981184503}, {-1.391338288426397, -3.493553549565278}}], 
        LineBox[{{-1.3895173657767712`, -3.6246956952954177`}, \
{-1.3889110878104278`, -2.8870540138682053`}}], 
        LineBox[{{-1.4308119554125818`, -5.298317366548036}, \
{-1.4303649487833152`, -4.306568202162434}}]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUWnc81e8Xt/e891pJkpE9olBkJBIZaZDxLRSJRImyQnZJWkhUFIpQRBnn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         "]], 
        LineBox[{{-0.274677743164378, -5.298317366548036}, \
{-0.27408705585431015`, -4.969485974757601}, {-0.273598930718067, \
-5.298317366548036}}], 
        LineBox[{{-0.2721308661865039, -5.298317366548036}, \
{-0.27164944546190495`, -5.099040171584874}, {-0.2710409310817236, \
-4.827102489230139}, {-0.27043278676611493`, -5.190183761590067}, \
{-0.27011722996158055`, -5.298317366548036}}], 
        LineBox[{{-0.2692932393090027, -5.298317366548036}, \
{-0.2692176845490116, -5.284095850375458}, {-0.268610647684061, \
-4.678386890519318}, {-0.26800405701359853`, -4.410781081388414}, \
{-0.2673977561952779, -4.831118370141682}, {-0.2671970924629547, \
-5.298317366548036}}], 
        LineBox[{{-0.2656315760385054, -5.298317366548036}, \
{-0.26558113396476035`, -5.285816629941033}, {-0.26497629994481253`, \
-4.720271339889647}, {-0.2643719091696942, -5.228139952607627}, \
{-0.26376780586728016`, -5.03739343249013}, {-0.26316406728534836`, \
-5.08188885025199}, {-0.262560770485036, -5.087528578106296}, \
{-0.26195775997776694`, -4.836499833344438}, {-0.26135511287304525`, \
-4.633771593023157}, {-0.26075290609440566`, -4.760675184375608}, \
{-0.26015098443578805`, -4.607324334564698}, {-0.2595494248689136, \
-4.364465508880019}, {-0.25894830418020226`, -3.4429375320786066`}}]}, {
        Hue[0.8503398874989481, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwcW3c8Vf8bt0cq4mqhpZCVFGU+9KVFEcrILKVsESmpNFFRRlZKIrOEklHn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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.487195066484062, -5.298317366548025}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.487195066484062, 
      1.6310721412512184`}, {-5.298317366548036, 11.512925464970229`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"C20_30.7138\"", "\"C20_10.0042\"", "\"C20_1.504\"", 
       "\"BG25_30.7138\"", "\"BG25_10.0042\"", "\"BG25_1.504\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.922526, 0.385626, 0.209179]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.528488, 0.470624, 0.701351]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.772079, 0.431554, 0.102387]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], "}"}], 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True", 
                 ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.843298149991452*^9, 3.843298203872168*^9, 3.8432982736696587`*^9, {
   3.843298384765218*^9, 3.843298404726954*^9}, 3.84329873022256*^9, {
   3.8432988004009867`*^9, 3.843298803824133*^9}, {3.843298872108584*^9, 
   3.843298895599083*^9}, {3.8432990149186*^9, 3.8432990770538588`*^9}, {
   3.843299137189081*^9, 3.8432991407725573`*^9}, {3.843299840648491*^9, 
   3.843299921480537*^9}, {3.843299960469057*^9, 3.843299972052854*^9}, 
   3.843300012041739*^9, 3.843300096769802*^9, {3.8433001291250687`*^9, 
   3.843300174678563*^9}, {3.852785009054036*^9, 3.852785030774148*^9}, {
   3.852787502594598*^9, 3.852787530539609*^9}, 3.852787791379717*^9, 
   3.852787910287105*^9, 3.852796869163835*^9, 3.8527969417886457`*^9, {
   3.852797012104776*^9, 3.852797018397952*^9}, 3.852862497566475*^9, 
   3.853381366813589*^9, 3.8533814753005857`*^9, 3.853402239868787*^9, 
   3.853469094796208*^9, 3.853496279768393*^9, 3.853499624685063*^9, 
   3.853817846160879*^9, 3.853818247955379*^9, 3.8538246853293123`*^9, 
   3.8538248725516987`*^9, 3.853833076731237*^9, 3.853836454739139*^9, 
   3.853836627576047*^9, 3.8538385410146437`*^9, 3.8540725564096527`*^9, 
   3.854091676757815*^9, 3.854098462801889*^9, 3.8544207604946127`*^9, 
   3.854421164446437*^9, 3.8544212040376797`*^9, 3.8544236563123503`*^9, 
   3.860120820146564*^9, 3.860120992755413*^9, 3.8601402097736197`*^9, 
   3.860141203197979*^9, 3.8617633271887465`*^9, 3.8617673254490795`*^9, 
   3.861941023959653*^9, 3.8619503178258157`*^9, 3.885973462316798*^9, {
   3.8859735791689806`*^9, 3.8859735863327785`*^9}, 3.8859747465859413`*^9, 
   3.8859747986681952`*^9, {3.885975027787902*^9, 3.8859750393330336`*^9}, 
   3.885976328509342*^9, 3.885977032989354*^9, 3.8859775404716673`*^9, 
   3.885979060483423*^9, 3.8859790972689905`*^9, {3.885979294595189*^9, 
   3.885979310657553*^9}, 3.885979644422537*^9, 3.8859798767472997`*^9, 
   3.8859802200758305`*^9, 3.885980276257719*^9, 3.885980545153112*^9, 
   3.885980685497188*^9, 3.8860616074751854`*^9, 3.886152225682108*^9, 
   3.888310978040262*^9, 3.889002269915166*^9, 3.8890603306392736`*^9, 
   3.889064568176372*^9, 3.889081913918378*^9, 3.8890827504249163`*^9, 
   3.889084480239011*^9, {3.8895035588509493`*^9, 3.8895035673865147`*^9}, {
   3.8895042405971904`*^9, 3.889504241091606*^9}, 3.88951548578316*^9, {
   3.8896687291557455`*^9, 3.889668742820923*^9}, 3.8896725906682463`*^9, 
   3.889672649616415*^9, 3.8896726992702703`*^9, {3.889672743456319*^9, 
   3.8896727596135435`*^9}, {3.889672989005809*^9, 3.889673014473555*^9}, 
   3.889673069643585*^9, {3.88967314352767*^9, 3.8896731597222066`*^9}, 
   3.8896731975865993`*^9, 3.8896763716560993`*^9, 3.890203528371027*^9, 
   3.8902035960444994`*^9, 3.8909804917392635`*^9, 3.8909815443374186`*^9, 
   3.8909827436668806`*^9, 3.8914160422882376`*^9, 3.8914972309806986`*^9, 
   3.891497552617916*^9, 3.8914985996710963`*^9, 3.892613780418276*^9, 
   3.8926144542256045`*^9, 3.892696025955387*^9, 3.90203710877135*^9, 
   3.9020419144279413`*^9, 3.9020420016973553`*^9, 3.902042180923932*^9, 
   3.902293482175687*^9, 3.9022966719387836`*^9, 3.9022975312223053`*^9, 
   3.9022975902341137`*^9, 3.902298365560647*^9},
 CellLabel->
  "Out[1178]=",ExpressionUUID->"2ecf406f-e30f-48f9-8335-7af38d4a9b1d"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C20 - volume - \
Playground\\\\DataRaw.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.843298149991452*^9, 3.843298203872168*^9, 3.8432982736696587`*^9, {
   3.843298384765218*^9, 3.843298404726954*^9}, 3.84329873022256*^9, {
   3.8432988004009867`*^9, 3.843298803824133*^9}, {3.843298872108584*^9, 
   3.843298895599083*^9}, {3.8432990149186*^9, 3.8432990770538588`*^9}, {
   3.843299137189081*^9, 3.8432991407725573`*^9}, {3.843299840648491*^9, 
   3.843299921480537*^9}, {3.843299960469057*^9, 3.843299972052854*^9}, 
   3.843300012041739*^9, 3.843300096769802*^9, {3.8433001291250687`*^9, 
   3.843300174678563*^9}, {3.852785009054036*^9, 3.852785030774148*^9}, {
   3.852787502594598*^9, 3.852787530539609*^9}, 3.852787791379717*^9, 
   3.852787910287105*^9, 3.852796869163835*^9, 3.8527969417886457`*^9, {
   3.852797012104776*^9, 3.852797018397952*^9}, 3.852862497566475*^9, 
   3.853381366813589*^9, 3.8533814753005857`*^9, 3.853402239868787*^9, 
   3.853469094796208*^9, 3.853496279768393*^9, 3.853499624685063*^9, 
   3.853817846160879*^9, 3.853818247955379*^9, 3.8538246853293123`*^9, 
   3.8538248725516987`*^9, 3.853833076731237*^9, 3.853836454739139*^9, 
   3.853836627576047*^9, 3.8538385410146437`*^9, 3.8540725564096527`*^9, 
   3.854091676757815*^9, 3.854098462801889*^9, 3.8544207604946127`*^9, 
   3.854421164446437*^9, 3.8544212040376797`*^9, 3.8544236563123503`*^9, 
   3.860120820146564*^9, 3.860120992755413*^9, 3.8601402097736197`*^9, 
   3.860141203197979*^9, 3.8617633271887465`*^9, 3.8617673254490795`*^9, 
   3.861941023959653*^9, 3.8619503178258157`*^9, 3.885973462316798*^9, {
   3.8859735791689806`*^9, 3.8859735863327785`*^9}, 3.8859747465859413`*^9, 
   3.8859747986681952`*^9, {3.885975027787902*^9, 3.8859750393330336`*^9}, 
   3.885976328509342*^9, 3.885977032989354*^9, 3.8859775404716673`*^9, 
   3.885979060483423*^9, 3.8859790972689905`*^9, {3.885979294595189*^9, 
   3.885979310657553*^9}, 3.885979644422537*^9, 3.8859798767472997`*^9, 
   3.8859802200758305`*^9, 3.885980276257719*^9, 3.885980545153112*^9, 
   3.885980685497188*^9, 3.8860616074751854`*^9, 3.886152225682108*^9, 
   3.888310978040262*^9, 3.889002269915166*^9, 3.8890603306392736`*^9, 
   3.889064568176372*^9, 3.889081913918378*^9, 3.8890827504249163`*^9, 
   3.889084480239011*^9, {3.8895035588509493`*^9, 3.8895035673865147`*^9}, {
   3.8895042405971904`*^9, 3.889504241091606*^9}, 3.88951548578316*^9, {
   3.8896687291557455`*^9, 3.889668742820923*^9}, 3.8896725906682463`*^9, 
   3.889672649616415*^9, 3.8896726992702703`*^9, {3.889672743456319*^9, 
   3.8896727596135435`*^9}, {3.889672989005809*^9, 3.889673014473555*^9}, 
   3.889673069643585*^9, {3.88967314352767*^9, 3.8896731597222066`*^9}, 
   3.8896731975865993`*^9, 3.8896763716560993`*^9, 3.890203528371027*^9, 
   3.8902035960444994`*^9, 3.8909804917392635`*^9, 3.8909815443374186`*^9, 
   3.8909827436668806`*^9, 3.8914160422882376`*^9, 3.8914972309806986`*^9, 
   3.891497552617916*^9, 3.8914985996710963`*^9, 3.892613780418276*^9, 
   3.8926144542256045`*^9, 3.892696025955387*^9, 3.90203710877135*^9, 
   3.9020419144279413`*^9, 3.9020420016973553`*^9, 3.902042180923932*^9, 
   3.902293482175687*^9, 3.9022966719387836`*^9, 3.9022975312223053`*^9, 
   3.9022975902341137`*^9, 3.902298367149705*^9},
 CellLabel->
  "Out[1179]=",ExpressionUUID->"7186329a-ec17-4c63-8e34-211adb49318c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Process data", "Subsubsection",
 CellChangeTimes->{{3.8601399392765074`*^9, 3.8601399407209606`*^9}, {
   3.8859798317515917`*^9, 3.885979836205883*^9}, 
   3.8896895105228753`*^9},ExpressionUUID->"c68dbf72-8a8c-4c44-a3ef-\
9c60b7918969"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Subtract", " ", "backgrounds"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dataToAnalyze", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
        RowBox[{
        "\"\<C20_30.7138\>\"", ",", "\"\<BG25_30.7138\>\"", ",", "1.1"}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{
         "\"\<C20_10.0042\>\"", ",", "\"\<BG25_10.0042\>\"", ",", "1.1"}], 
         "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"wat", " ", "doen", " ", "de", " ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"0", ",", "4"}], "}"}]}], "}"}], "?", " ", "--"}]}], 
         ">", " ", 
         RowBox[{
         "vermenigvuldig", " ", "alle", " ", "intensity", " ", "waardes", " ",
           "met", " ", "4"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{
         "\"\<C20_1.504\>\"", ",", "\"\<BG25_1.504\>\"", ",", "1.05"}], "]"}],
         ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plotDataSubtracted", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"dataToAnalyze", ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<31 m\>\"", ",", " ", "\"\<10 m\>\"", ",", " ", "\"\<1.5 m\>\""}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", 
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "5"}]}], ",", 
           RowBox[{"10", "^", "5"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataSubtracted.pdf\>\""}], "}"}], "]"}], ",", 
     "plotDataSubtracted"}], " ", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.852787913735702*^9, 3.852788081126293*^9}, {
   3.852788124237091*^9, 3.852788221803185*^9}, {3.85278830511749*^9, 
   3.852788314820683*^9}, 3.852788353883409*^9, {3.8527951901832237`*^9, 
   3.852795266554426*^9}, {3.852795790301991*^9, 3.852795801188776*^9}, {
   3.8534052664208517`*^9, 3.853405359776355*^9}, 3.853405404221602*^9, {
   3.853409748113482*^9, 3.8534097682258587`*^9}, 3.853410243789892*^9, {
   3.853410568646674*^9, 3.853410593142272*^9}, {3.8538366552098618`*^9, 
   3.853836688425962*^9}, {3.8544213058580093`*^9, 3.8544213392155523`*^9}, {
   3.854421399974036*^9, 3.854421487835609*^9}, {3.860120980130918*^9, 
   3.8601209825914593`*^9}, {3.8601399447486825`*^9, 3.860139952932967*^9}, {
   3.861763386455724*^9, 3.8617634066433244`*^9}, {3.8617636721585855`*^9, 
   3.8617636911551275`*^9}, 3.861763753820904*^9, {3.861763829259494*^9, 
   3.8617638295877748`*^9}, {3.8617640171756115`*^9, 
   3.8617640685814066`*^9}, {3.861764108969255*^9, 3.8617641095314784`*^9}, {
   3.8617641469152203`*^9, 3.8617641470504246`*^9}, {3.8617642667147017`*^9, 
   3.861764269211673*^9}, {3.861764301965845*^9, 3.8617643679072943`*^9}, {
   3.861764616394006*^9, 3.861764629873103*^9}, {3.8617647074999027`*^9, 
   3.861764707889408*^9}, {3.861767331688716*^9, 3.8617674531915107`*^9}, {
   3.8619430250008717`*^9, 3.8619430252780623`*^9}, 3.885975125250722*^9, {
   3.885975162956421*^9, 3.8859751687928877`*^9}, {3.885975253564953*^9, 
   3.885975292171652*^9}, {3.8859753684038987`*^9, 3.8859753944654756`*^9}, {
   3.8859764080472107`*^9, 3.885976444462107*^9}, {3.8859766205505714`*^9, 
   3.885976701234559*^9}, {3.885977061431158*^9, 3.885977105613533*^9}, {
   3.8859775666625447`*^9, 3.8859775972455435`*^9}, {3.8859793109661627`*^9, 
   3.8859793451759176`*^9}, {3.8859793845178595`*^9, 
   3.8859794119426813`*^9}, {3.8859794524741387`*^9, 3.885979469919469*^9}, {
   3.8859796644128475`*^9, 3.8859797943053474`*^9}, {3.885979909660304*^9, 
   3.885979925707234*^9}, {3.885980058912956*^9, 3.8859800719340887`*^9}, {
   3.8859802956113253`*^9, 3.885980299515154*^9}, {3.8859803946280155`*^9, 
   3.8859804083447933`*^9}, {3.8859805548112154`*^9, 3.885980558763019*^9}, {
   3.8859806884189878`*^9, 3.8859807559686003`*^9}, {3.886061779883998*^9, 
   3.8860618911826696`*^9}, {3.886062270796764*^9, 3.8860623299442167`*^9}, {
   3.88606290416301*^9, 3.88606290438365*^9}, {3.886152279651626*^9, 
   3.8861523073398314`*^9}, {3.8861523706298904`*^9, 
   3.8861523714286704`*^9}, {3.888311253563958*^9, 3.8883112815379667`*^9}, {
   3.8895154757176466`*^9, 3.889515521326418*^9}, 3.889668778999714*^9, {
   3.8896725208785334`*^9, 3.889672555662263*^9}, {3.8896761687511916`*^9, 
   3.8896761875813046`*^9}, {3.8896762430656424`*^9, 3.8896763228575*^9}, {
   3.890203680281665*^9, 3.8902036879233007`*^9}, {3.890203721626855*^9, 
   3.8902037336503353`*^9}, {3.890203765562109*^9, 3.890203784550714*^9}, {
   3.890216653073305*^9, 3.89021672873991*^9}, {3.8902167682576685`*^9, 
   3.890216804044831*^9}, {3.89021744880861*^9, 3.890217482686234*^9}, {
   3.8902177558058324`*^9, 3.890217761492506*^9}, {3.8909816465407667`*^9, 
   3.890981653810565*^9}, {3.8909826260035453`*^9, 3.89098264917115*^9}, {
   3.890982718701262*^9, 3.890982720715917*^9}, {3.8914972861846867`*^9, 
   3.8914972916516743`*^9}, {3.89149732190543*^9, 3.891497325080738*^9}, {
   3.8914973608592787`*^9, 3.891497387301942*^9}, {3.8914981362303147`*^9, 
   3.8914982511085134`*^9}, {3.891498313222266*^9, 3.8914983218384113`*^9}, {
   3.891498500855095*^9, 3.891498501109005*^9}, {3.902293403750101*^9, 
   3.9022934262445173`*^9}, 3.902293761601369*^9, 3.9022937955237455`*^9, {
   3.9022959828127484`*^9, 3.902295995749625*^9}, {3.9022961816469045`*^9, 
   3.902296183148714*^9}, {3.902296613680443*^9, 3.902296659428668*^9}, {
   3.9022974286181245`*^9, 3.902297523060432*^9}, {3.9022975813047495`*^9, 
   3.9022975816086473`*^9}, {3.902298249355943*^9, 3.9022983180114884`*^9}, {
   3.9022983493393493`*^9, 3.902298349806218*^9}, {3.9023034979806356`*^9, 
   3.902303498185611*^9}},
 CellLabel->
  "In[1230]:=",ExpressionUUID->"5cc1674a-6b09-4f41-a48c-1487561a3f0f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c4lt8ffvdr71FGIkU0pFQi58m3ZIWWSEISSoi2yki0ZVSSTUhEAyGd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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c81P8fv+HscUdIJZGUrUgk3WWm0EDIyCqVsorqa5RRVklUSClKNElJ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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c8lt8btkcpsuf7vkaplNIgIzdFfWUlKis0UBmljFASUlqIskohEhkh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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.487169751504421, -11.512925464970204`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.487169751504421, 
      1.630470845239991}, {-11.512925464970229`, 11.512925464970229`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"31 m\"", "\"10 m\"", "\"1.5 m\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.8527879438310833`*^9, 3.852787964921023*^9}, {
   3.8527880302138367`*^9, 3.8527880537745132`*^9}, 3.852788084697062*^9, {
   3.8527881270170593`*^9, 3.852788224333301*^9}, 3.85278831785238*^9, 
   3.852788361683811*^9, {3.852795206034478*^9, 3.852795268644823*^9}, {
   3.852795796660235*^9, 3.852795803347172*^9}, 3.852862499690114*^9, 
   3.853381367103548*^9, 3.853381477275778*^9, 3.8534022418114157`*^9, 
   3.853402534499599*^9, {3.853405270422613*^9, 3.853405324836055*^9}, 
   3.853405407395211*^9, {3.8534097505906153`*^9, 3.8534097703076878`*^9}, 
   3.853410187279647*^9, 3.8534102457215548`*^9, {3.853410571397106*^9, 
   3.853410595830978*^9}, 3.853469096590513*^9, 3.853469303037784*^9, 
   3.853496283640119*^9, 3.8534996296665163`*^9, 3.853817848440113*^9, 
   3.8538182517655993`*^9, 3.853824687596098*^9, 3.85382487471694*^9, 
   3.8538330798017387`*^9, 3.853836456463883*^9, {3.853836638285132*^9, 
   3.853836690462969*^9}, 3.853838543040962*^9, 3.854072558224156*^9, 
   3.854091678576386*^9, 3.8540984652252827`*^9, 3.8544207625736847`*^9, 
   3.854421344558304*^9, {3.8544214059054337`*^9, 3.854421491046699*^9}, 
   3.854423662477191*^9, 3.8601208220618477`*^9, 3.860120994483048*^9, 
   3.86012125099901*^9, 3.860140222318944*^9, 3.8601412086662254`*^9, 
   3.861763743975759*^9, 3.86176383617095*^9, {3.8617640582820826`*^9, 
   3.861764074747286*^9}, 3.8617641740186996`*^9, 3.861764274902935*^9, {
   3.8617643353175488`*^9, 3.861764372253722*^9}, {3.861764623510527*^9, 
   3.8617646348513403`*^9}, 3.8617647132308836`*^9, {3.861767375375707*^9, 
   3.861767457590822*^9}, 3.861941029316691*^9, 3.861950322744031*^9, 
   3.8636862718685603`*^9, 3.8636872310576773`*^9, 3.885975309403617*^9, {
   3.885975375253332*^9, 3.885975398991347*^9}, 3.885976450290474*^9, {
   3.8859766273930984`*^9, 3.885976705321181*^9}, {3.885977079657692*^9, 
   3.8859771107489624`*^9}, 3.885977602788784*^9, {3.885979327503832*^9, 
   3.885979350000666*^9}, {3.8859793893365097`*^9, 3.8859794164248023`*^9}, {
   3.885979462547427*^9, 3.8859794743961115`*^9}, {3.8859797044283705`*^9, 
   3.8859797993350043`*^9}, {3.885979917813003*^9, 3.885979931062524*^9}, {
   3.8859800636906133`*^9, 3.8859800779593983`*^9}, 3.885980312698554*^9, {
   3.8859804016551037`*^9, 3.8859804126591787`*^9}, 3.8859805640552745`*^9, {
   3.885980715872667*^9, 3.8859807602126627`*^9}, {3.8860618090326586`*^9, 
   3.886061895699357*^9}, {3.8860622756094923`*^9, 3.8860623347401624`*^9}, 
   3.8860629092400513`*^9, {3.886152285047185*^9, 3.8861523259663725`*^9}, 
   3.8861523762490544`*^9, 3.888310979206479*^9, {3.888311255213608*^9, 
   3.888311282957345*^9}, 3.8890022856520777`*^9, 3.889060337400128*^9, 
   3.889064570327097*^9, 3.8890819151049967`*^9, 3.889082751667604*^9, 
   3.889084481475959*^9, 3.889504256968684*^9, 3.8895154808895187`*^9, 
   3.8895155265896363`*^9, {3.8896687737857976`*^9, 3.8896687838826714`*^9}, 
   3.8896725629108257`*^9, {3.8896761751473627`*^9, 3.889676192632434*^9}, 
   3.889676249961451*^9, {3.8896763044816694`*^9, 3.8896763296834364`*^9}, {
   3.890203672586771*^9, 3.8902037015966415`*^9}, 3.8902037493461847`*^9, 
   3.8902037965747986`*^9, {3.890216658915124*^9, 3.8902167333765697`*^9}, {
   3.890216774140562*^9, 3.890216809078682*^9}, {3.8902174567679343`*^9, 
   3.8902174874612885`*^9}, 3.890217766852687*^9, 3.8909816129922285`*^9, 
   3.890981659451852*^9, {3.890982631522698*^9, 3.890982655851638*^9}, {
   3.890982726501892*^9, 3.8909827519660463`*^9}, 3.891416093072353*^9, 
   3.89149730439897*^9, 3.891497334536474*^9, {3.891497375192842*^9, 
   3.8914973992304735`*^9}, 3.8914975640870247`*^9, {3.8914981450974956`*^9, 
   3.8914982596763473`*^9}, 3.8914983355783367`*^9, 3.891498513742013*^9, 
   3.891498617526591*^9, 3.892613683076393*^9, 3.8926137878875275`*^9, 
   3.892614320742548*^9, 3.8926144631009235`*^9, 3.892696050709646*^9, 
   3.9020371141886473`*^9, 3.9020422033450956`*^9, {3.902293414600558*^9, 
   3.902293439245744*^9}, 3.9022934916413555`*^9, 3.902293767397822*^9, 
   3.9022938022186637`*^9, {3.9022959884699297`*^9, 3.902296000596073*^9}, 
   3.9022961900584164`*^9, 3.9022966191801615`*^9, {3.902296649643454*^9, 
   3.902296681008383*^9}, {3.9022974388816366`*^9, 3.902297539721385*^9}, 
   3.9022976000269976`*^9, {3.9022982677659383`*^9, 3.9022983044354506`*^9}, {
   3.9022983547556195`*^9, 3.902298374198013*^9}, 3.902303513746819*^9},
 CellLabel->
  "Out[1231]=",ExpressionUUID->"21d00090-065e-45e3-b37e-961e437fa996"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C20 - volume - \
Playground\\\\DataSubtracted.pdf\"\>"], "Output",
 CellChangeTimes->{{3.8527879438310833`*^9, 3.852787964921023*^9}, {
   3.8527880302138367`*^9, 3.8527880537745132`*^9}, 3.852788084697062*^9, {
   3.8527881270170593`*^9, 3.852788224333301*^9}, 3.85278831785238*^9, 
   3.852788361683811*^9, {3.852795206034478*^9, 3.852795268644823*^9}, {
   3.852795796660235*^9, 3.852795803347172*^9}, 3.852862499690114*^9, 
   3.853381367103548*^9, 3.853381477275778*^9, 3.8534022418114157`*^9, 
   3.853402534499599*^9, {3.853405270422613*^9, 3.853405324836055*^9}, 
   3.853405407395211*^9, {3.8534097505906153`*^9, 3.8534097703076878`*^9}, 
   3.853410187279647*^9, 3.8534102457215548`*^9, {3.853410571397106*^9, 
   3.853410595830978*^9}, 3.853469096590513*^9, 3.853469303037784*^9, 
   3.853496283640119*^9, 3.8534996296665163`*^9, 3.853817848440113*^9, 
   3.8538182517655993`*^9, 3.853824687596098*^9, 3.85382487471694*^9, 
   3.8538330798017387`*^9, 3.853836456463883*^9, {3.853836638285132*^9, 
   3.853836690462969*^9}, 3.853838543040962*^9, 3.854072558224156*^9, 
   3.854091678576386*^9, 3.8540984652252827`*^9, 3.8544207625736847`*^9, 
   3.854421344558304*^9, {3.8544214059054337`*^9, 3.854421491046699*^9}, 
   3.854423662477191*^9, 3.8601208220618477`*^9, 3.860120994483048*^9, 
   3.86012125099901*^9, 3.860140222318944*^9, 3.8601412086662254`*^9, 
   3.861763743975759*^9, 3.86176383617095*^9, {3.8617640582820826`*^9, 
   3.861764074747286*^9}, 3.8617641740186996`*^9, 3.861764274902935*^9, {
   3.8617643353175488`*^9, 3.861764372253722*^9}, {3.861764623510527*^9, 
   3.8617646348513403`*^9}, 3.8617647132308836`*^9, {3.861767375375707*^9, 
   3.861767457590822*^9}, 3.861941029316691*^9, 3.861950322744031*^9, 
   3.8636862718685603`*^9, 3.8636872310576773`*^9, 3.885975309403617*^9, {
   3.885975375253332*^9, 3.885975398991347*^9}, 3.885976450290474*^9, {
   3.8859766273930984`*^9, 3.885976705321181*^9}, {3.885977079657692*^9, 
   3.8859771107489624`*^9}, 3.885977602788784*^9, {3.885979327503832*^9, 
   3.885979350000666*^9}, {3.8859793893365097`*^9, 3.8859794164248023`*^9}, {
   3.885979462547427*^9, 3.8859794743961115`*^9}, {3.8859797044283705`*^9, 
   3.8859797993350043`*^9}, {3.885979917813003*^9, 3.885979931062524*^9}, {
   3.8859800636906133`*^9, 3.8859800779593983`*^9}, 3.885980312698554*^9, {
   3.8859804016551037`*^9, 3.8859804126591787`*^9}, 3.8859805640552745`*^9, {
   3.885980715872667*^9, 3.8859807602126627`*^9}, {3.8860618090326586`*^9, 
   3.886061895699357*^9}, {3.8860622756094923`*^9, 3.8860623347401624`*^9}, 
   3.8860629092400513`*^9, {3.886152285047185*^9, 3.8861523259663725`*^9}, 
   3.8861523762490544`*^9, 3.888310979206479*^9, {3.888311255213608*^9, 
   3.888311282957345*^9}, 3.8890022856520777`*^9, 3.889060337400128*^9, 
   3.889064570327097*^9, 3.8890819151049967`*^9, 3.889082751667604*^9, 
   3.889084481475959*^9, 3.889504256968684*^9, 3.8895154808895187`*^9, 
   3.8895155265896363`*^9, {3.8896687737857976`*^9, 3.8896687838826714`*^9}, 
   3.8896725629108257`*^9, {3.8896761751473627`*^9, 3.889676192632434*^9}, 
   3.889676249961451*^9, {3.8896763044816694`*^9, 3.8896763296834364`*^9}, {
   3.890203672586771*^9, 3.8902037015966415`*^9}, 3.8902037493461847`*^9, 
   3.8902037965747986`*^9, {3.890216658915124*^9, 3.8902167333765697`*^9}, {
   3.890216774140562*^9, 3.890216809078682*^9}, {3.8902174567679343`*^9, 
   3.8902174874612885`*^9}, 3.890217766852687*^9, 3.8909816129922285`*^9, 
   3.890981659451852*^9, {3.890982631522698*^9, 3.890982655851638*^9}, {
   3.890982726501892*^9, 3.8909827519660463`*^9}, 3.891416093072353*^9, 
   3.89149730439897*^9, 3.891497334536474*^9, {3.891497375192842*^9, 
   3.8914973992304735`*^9}, 3.8914975640870247`*^9, {3.8914981450974956`*^9, 
   3.8914982596763473`*^9}, 3.8914983355783367`*^9, 3.891498513742013*^9, 
   3.891498617526591*^9, 3.892613683076393*^9, 3.8926137878875275`*^9, 
   3.892614320742548*^9, 3.8926144631009235`*^9, 3.892696050709646*^9, 
   3.9020371141886473`*^9, 3.9020422033450956`*^9, {3.902293414600558*^9, 
   3.902293439245744*^9}, 3.9022934916413555`*^9, 3.902293767397822*^9, 
   3.9022938022186637`*^9, {3.9022959884699297`*^9, 3.902296000596073*^9}, 
   3.9022961900584164`*^9, 3.9022966191801615`*^9, {3.902296649643454*^9, 
   3.902296681008383*^9}, {3.9022974388816366`*^9, 3.902297539721385*^9}, 
   3.9022976000269976`*^9, {3.9022982677659383`*^9, 3.9022983044354506`*^9}, {
   3.9022983547556195`*^9, 3.902298374198013*^9}, 3.9023035193183026`*^9},
 CellLabel->
  "Out[1232]=",ExpressionUUID->"fefc8723-ab86-46c2-868e-3d96933ccacc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Merge", " ", 
    RowBox[{"(", "relevant", ")"}], " ", "patterns"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Usually", " ", "we", " ", "only", " ", "merge", " ", "pattern", " ", "2",
      " ", "and", " ", "3"}], ",", " ", 
    RowBox[{
    "but", " ", "sometimes", " ", "we", " ", "also", " ", "use", " ", "1", 
     " ", "when", " ", "2", " ", "contains", " ", "a", " ", "weird", " ", 
     "kink", " ", "or", " ", "noise", " ", "etc"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"only", " ", "pattern", " ", "2", " ", "and", " ", "3"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.1"}], "&"}]}], "]"}], ",",
        " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"default", ":", " ", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.06", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], "&"}]}], "]"}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"default", ":", " ", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"only", " ", "pattern", " ", "1", " ", "and", " ", "3"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.1"}], "&"}]}], "]"}], ",",
        " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"default", ":", " ", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.06", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], "&"}]}], "]"}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"default", ":", " ", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Sequential", " ", "merging", " ", "of", " ", "first", " ", "pattern", 
     " ", "1"}], " ", "+", " ", 
    RowBox[{"2", " ", "and", " ", "then", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "2"}], ")"}]}], " ", "+", " ", "3"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"datamerged1", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.004", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], "&"}]}], "]"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"default", ":", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], "*)"}], 
       " ", 
       RowBox[{"(*", " ", 
        RowBox[{"0.005", "<", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], " ", "*)"}], " ", 
       RowBox[{"(*", " ", 
        RowBox[{"0.02", "<", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.1", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}], "&"}]}], "]"}]}], 
      " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"default", ":", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{"datamerged1", ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.3"}], "&"}]}], "]"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"default", ":", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.05", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}], "&"}]}], "]"}]}], 
      " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"default", ":", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], "*)"}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"0.05", "<", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", "1"}], " ", "*)"}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"0.05", "<", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", "0.7"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
    RowBox[{"datamerged1", ",", "\[IndentingNewLine]", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
     " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
       " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
       "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plotDataMerged", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamerged", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMerged.pdf\>\""}], "}"}], "]"}], ",", "plotDataMerged"}], 
    " ", "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Bin", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinned", "=", 
     RowBox[{"binData", "[", 
      RowBox[{"datamerged", ",", "0.05"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"default", ":", " ", "0.05"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotDataBinned", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamergedbinned", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMergedBinned.pdf\>\""}], "}"}], "]"}], ",", 
     "plotDataBinned"}], " ", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Export", " ", "merged", " ", "and", " ", "binned", " ", "data", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", "datamergedbinned", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS data merged and binned.csv\>\""}]}], 
       "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", "exportlist"}], "\[IndentingNewLine]", 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.854423668689094*^9, 3.854423681960602*^9}, {
   3.8601210812169123`*^9, 3.8601211773702602`*^9}, {3.860121220142*^9, 
   3.860121220876803*^9}, {3.860121492525386*^9, 3.8601215079101877`*^9}, {
   3.860121718604267*^9, 3.8601217659879427`*^9}, {3.860121814486486*^9, 
   3.860121940090294*^9}, {3.860121990307417*^9, 3.860122029773138*^9}, {
   3.86012227550008*^9, 3.860122412026474*^9}, {3.860123590194846*^9, 
   3.8601236144362907`*^9}, 3.8601236508219957`*^9, {3.860139958454444*^9, 
   3.8601400142502003`*^9}, {3.8601409041122975`*^9, 
   3.8601409737863803`*^9}, {3.860141247131112*^9, 3.8601412486662936`*^9}, 
   3.860141363728487*^9, {3.861764464753133*^9, 3.8617644999883156`*^9}, {
   3.8617650690038815`*^9, 3.861765107161731*^9}, {3.8617654080879517`*^9, 
   3.8617654464808097`*^9}, {3.8617667857822647`*^9, 3.861766817572381*^9}, {
   3.861767478263466*^9, 3.8617674824174633`*^9}, {3.8617675156782837`*^9, 
   3.8617675385223627`*^9}, {3.861767600750394*^9, 3.8617678801582737`*^9}, {
   3.861768004639906*^9, 3.861768004842128*^9}, {3.8617680471976347`*^9, 
   3.8617680542883253`*^9}, 3.8617682512241673`*^9, {3.8619408859545107`*^9, 
   3.8619408879723635`*^9}, 3.8619500601432023`*^9, {3.8859755937637935`*^9, 
   3.8859756289602833`*^9}, {3.8859767824682684`*^9, 
   3.8859768072202587`*^9}, {3.885976912247283*^9, 3.885976915489427*^9}, {
   3.885977184321333*^9, 3.8859771875417037`*^9}, {3.8859772431391516`*^9, 
   3.8859772459190493`*^9}, {3.8859776946505795`*^9, 3.885977697414628*^9}, {
   3.885977754450777*^9, 3.8859777568929634`*^9}, {3.8859804425147095`*^9, 
   3.8859804438235583`*^9}, 3.8859804753994827`*^9, {3.8859807731997614`*^9, 
   3.885980782688805*^9}, 3.8860629984459877`*^9, {3.886063060466019*^9, 
   3.8860631273919067`*^9}, {3.886071125028043*^9, 3.8860711896934166`*^9}, {
   3.8860714254613867`*^9, 3.8860714550837*^9}, {3.8895154616447597`*^9, 
   3.8895154658794193`*^9}, {3.8896724114246473`*^9, 3.889672412507053*^9}, {
   3.889672471225835*^9, 3.8896725071452694`*^9}, {3.889674589350315*^9, 
   3.889674633174043*^9}, {3.889674670910601*^9, 3.889674765787591*^9}, {
   3.8896748131059356`*^9, 3.889674848516157*^9}, {3.8896748918371353`*^9, 
   3.8896749698660383`*^9}, {3.8896759808235216`*^9, 
   3.8896760211101522`*^9}, {3.8896760618397036`*^9, 3.889676134804789*^9}, {
   3.8896766120107994`*^9, 3.8896766124494815`*^9}, {3.889676755304323*^9, 
   3.889676755581999*^9}, {3.8902038545244083`*^9, 3.890203901273981*^9}, {
   3.890205930477414*^9, 3.8902059314228735`*^9}, {3.8902102550185256`*^9, 
   3.890210255342898*^9}, 3.8902167482021494`*^9, {3.8902168284956217`*^9, 
   3.89021682871568*^9}, {3.890216868216955*^9, 3.8902168763206763`*^9}, {
   3.8902172079856234`*^9, 3.8902172082346754`*^9}, {3.890981726002406*^9, 
   3.890981786213588*^9}, {3.8909822356137176`*^9, 3.8909822357713594`*^9}, {
   3.8914985305692663`*^9, 3.8914985803250184`*^9}, {3.892613758123871*^9, 
   3.892613758289031*^9}, {3.892614278506711*^9, 3.892614293126571*^9}, {
   3.892614333217201*^9, 3.892614379152516*^9}, {3.9022938086532*^9, 
   3.902293808923072*^9}},
 CellLabel->
  "In[1183]:=",ExpressionUUID->"5b3c3b75-f6f9-43b4-ae93-bf843c1633be"],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 1184, 52, 17025713724928210084, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.902297602271044*^9, 3.9022983775529084`*^9},
 CellLabel->
  "During evaluation of \
In[1183]:=",ExpressionUUID->"d4898c80-e65d-4d71-b980-7bf78e8520e7"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.004583333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwUV3c81e8Xv/tee1NGIpuK0FI9n2REQgslSopISJqSkZY00RBFFIlQ4Wv1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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.70445447981363, -5.6608614872390515`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{{{-6.907755278982137, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {2.302585092994046, 
        FormBox[
         TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {4.605170185988092, 
        FormBox[
         TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {6.907755278982137, 
        FormBox[
         TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {9.210340371976184, 
        FormBox[
         TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}}, {{{{-6.907755278982137, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {2.302585092994046, 
        FormBox[
         TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {4.605170185988092, 
        FormBox[
         TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {6.907755278982137, 
        FormBox[
         TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {9.210340371976184, 
        FormBox[
         TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}, {{{-5.298317366548036, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.005\"", ShowStringCharacters -> False], 
           0.005`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.050\"", ShowStringCharacters -> False], 
           0.05`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.500\"", ShowStringCharacters -> False], 
           0.5`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.70445447981363, -0.6940203524770587}, {-5.6608614872390515`,
    6.370459707155036}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.902298377775674*^9},
 CellLabel->
  "Out[1185]=",ExpressionUUID->"5b560024-6282-466a-a549-396dfcc34778"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwVl2c41m8bx2/jdu9tVKhIGdlaQr+LEBokSclKKhJCGlRIQ6XMjMiqtISs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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.704448486735667, -5.62051733983807},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20000], 9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30000], 10.308952660644293`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40000], 10.596634733096073`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50000], 10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60000], 11.002099841204238`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70000], 11.156250521031495`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80000], 11.289781913656018`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90000], 11.407564949312402`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20000], 9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30000], 10.308952660644293`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40000], 10.596634733096073`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50000], 10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60000], 11.002099841204238`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70000], 11.156250521031495`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80000], 11.289781913656018`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90000], 11.407564949312402`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.704448486735667, -0.6941627035247665}, {-5.62051733983807, 
   6.370459707155036}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.9022983785560513`*^9},
 CellLabel->
  "Out[1186]=",ExpressionUUID->"481d6955-79dc-4843-ad62-39960887fa66"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C20 - volume - \
Playground\\\\DataMerged.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.902298380055106*^9},
 CellLabel->
  "Out[1187]=",ExpressionUUID->"d6360753-c17e-4f6a-96c4-7b7e5977fabe"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.483842181677217, 6.332267788392241}, {-5.483842181677217,
          6.35145520112369}}], 
        LineBox[{{-5.483842181677217, 6.35145520112369}, {-5.483842181677217, 
         6.370281377367599}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.380228407219979, 6.156375565843266}, {-5.380228407219979,
          6.181225944599282}}], 
        LineBox[{{-5.380228407219979, 6.181225944599282}, {-5.380228407219979,
          6.2054737265324516`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.286352047426554, 
         5.9973371984940504`}, {-5.286352047426554, 6.023066046478073}}], 
        LineBox[{{-5.286352047426554, 6.023066046478073}, {-5.286352047426554,
          6.04814949160639}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.228332740694611, 
         5.9031764307698005`}, {-5.228332740694611, 5.926880423702094}}], 
        LineBox[{{-5.228332740694611, 5.926880423702094}, {-5.228332740694611,
          5.950035523214047}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.1734965151745005`, 
         5.785592932761042}, {-5.1734965151745005`, 5.80280779754565}}], 
        LineBox[{{-5.1734965151745005`, 
         5.80280779754565}, {-5.1734965151745005`, 5.8197313191215185`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.121512103387059, 5.703486967223862}, {-5.121512103387059,
          5.722354987080129}}], 
        LineBox[{{-5.121512103387059, 5.722354987080129}, {-5.121512103387059,
          5.740873587443014}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.0720974097604925`, 
         5.621145918297111}, {-5.0720974097604925`, 5.6396789767591375`}}], 
        LineBox[{{-5.0720974097604925`, 
         5.6396789767591375`}, {-5.0720974097604925`, 5.657874801461402}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.025010372042255, 5.526205369277399}, {-5.025010372042255,
          5.550523698210965}}], 
        LineBox[{{-5.025010372042255, 5.550523698210965}, {-5.025010372042255,
          5.574264658876496}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.980041374477484, 5.446638613359558}, {-4.980041374477484,
          5.4723918294160026`}}], 
        LineBox[{{-4.980041374477484, 
         5.4723918294160026`}, {-4.980041374477484, 5.497498434800429}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.92662358321994, 5.356218893512296}, {-4.92662358321994, 
         5.3756976672670795`}}], 
        LineBox[{{-4.92662358321994, 5.3756976672670795`}, {-4.92662358321994,
          5.394804256549144}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.87574337247038, 5.274931115486365}, {-4.87574337247038, 
         5.291053413102918}}], 
        LineBox[{{-4.87574337247038, 5.291053413102918}, {-4.87574337247038, 
         5.306919901026014}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.827483513108963, 5.17607691593067}, {-4.827483513108963, 
         5.200968616845535}}], 
        LineBox[{{-4.827483513108963, 5.200968616845535}, {-4.827483513108963,
          5.225255739509841}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.77239942676781, 5.071643748632878}, {-4.77239942676781, 
         5.093679604897293}}], 
        LineBox[{{-4.77239942676781, 5.093679604897293}, {-4.77239942676781, 
         5.1152403332399725`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.720192452293243, 4.977873307895476}, {-4.720192452293243,
          4.99363862570167}}], 
        LineBox[{{-4.720192452293243, 4.99363862570167}, {-4.720192452293243, 
         5.009159250929224}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.670576785004793, 4.881006861233649}, {-4.670576785004793,
          4.89889707406983}}], 
        LineBox[{{-4.670576785004793, 4.89889707406983}, {-4.670576785004793, 
         4.916472844394972}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.623307322213241, 4.799491238281539}, {-4.623307322213241,
          4.816156779950949}}], 
        LineBox[{{-4.623307322213241, 4.816156779950949}, {-4.623307322213241,
          4.8325491280408714`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.578172095309458, 4.703220123816942}, {-4.578172095309458,
          4.718950131429895}}], 
        LineBox[{{-4.578172095309458, 4.718950131429895}, {-4.578172095309458,
          4.734436532884893}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.528024063416046, 4.604814237574135}, {-4.528024063416046,
          4.6258761312036505`}}], 
        LineBox[{{-4.528024063416046, 
         4.6258761312036505`}, {-4.528024063416046, 4.646503556467098}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.473567500947851, 4.497350073609051}, {-4.473567500947851,
          4.51230217964658}}], 
        LineBox[{{-4.473567500947851, 4.51230217964658}, {-4.473567500947851, 
         4.527034009754865}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.4219245540939545`, 
         4.390221268237085}, {-4.4219245540939545`, 4.409523323142806}}], 
        LineBox[{{-4.4219245540939545`, 
         4.409523323142806}, {-4.4219245540939545`, 4.428459852976448}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.372818566555532, 4.293961911984705}, {-4.372818566555532,
          4.31150936454957}}], 
        LineBox[{{-4.372818566555532, 4.31150936454957}, {-4.372818566555532, 
         4.328754206438605}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.326011954933506, 4.216711576018824}, {-4.326011954933506,
          4.227552760667896}}], 
        LineBox[{{-4.326011954933506, 4.227552760667896}, {-4.326011954933506,
          4.238277673430781}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.275892138786888, 4.112461515658199}, {-4.275892138786888,
          4.130717782410805}}], 
        LineBox[{{-4.275892138786888, 4.130717782410805}, {-4.275892138786888,
          4.14864672468265}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.222951251037713, 4.007983319529881}, {-4.222951251037713,
          4.023121003676567}}], 
        LineBox[{{-4.222951251037713, 4.023121003676567}, {-4.222951251037713,
          4.038032951224964}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.172673294218139, 3.896515735572213}, {-4.172673294218139,
          3.91733697211612}}], 
        LineBox[{{-4.172673294218139, 3.91733697211612}, {-4.172673294218139, 
         3.9377335124395536`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.124803134014643, 
         3.8057498639594614`}, {-4.124803134014643, 3.8237898500823797`}}], 
        LineBox[{{-4.124803134014643, 
         3.8237898500823797`}, {-4.124803134014643, 3.8415101536586405`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.074701219535939, 3.708201385744695}, {-4.074701219535939,
          3.719938538917089}}], 
        LineBox[{{-4.074701219535939, 3.719938538917089}, {-4.074701219535939,
          3.731539527959118}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.026921534839552, 3.629623065780946}, {-4.026921534839552,
          3.63746754985972}}], 
        LineBox[{{-4.026921534839552, 3.63746754985972}, {-4.026921534839552, 
         3.6452509766602152`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.9773780413268547`, 
         3.5180374425816248`}, {-3.9773780413268547`, 3.530725095255669}}], 
        LineBox[{{-3.9773780413268547`, 
         3.530725095255669}, {-3.9773780413268547`, 3.543253786145549}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.9262371908045295`, 
         3.410587003727016}, {-3.9262371908045295`, 3.4238861329709507`}}], 
        LineBox[{{-3.9262371908045295`, 
         3.4238861329709507`}, {-3.9262371908045295`, 3.4370107141743302`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.8776461425773476`, 
         3.3066253433589923`}, {-3.8776461425773476`, 3.322504390142283}}], 
        LineBox[{{-3.8776461425773476`, 
         3.322504390142283}, {-3.8776461425773476`, 3.338135228970791}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.827799486652153, 3.177833393466894}, {-3.827799486652153,
          3.1936623784065583`}}], 
        LineBox[{{-3.827799486652153, 
         3.1936623784065583`}, {-3.827799486652153, 3.209244705849969}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.7770410262852683`, 
         3.087538449957183}, {-3.7770410262852683`, 3.0999135466087546`}}], 
        LineBox[{{-3.7770410262852683`, 
         3.0999135466087546`}, {-3.7770410262852683`, 3.1121373703531185`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.7255676492705025`, 
         2.966693706834019}, {-3.7255676492705025`, 2.9786869800120774`}}], 
        LineBox[{{-3.7255676492705025`, 
         2.9786869800120774`}, {-3.7255676492705025`, 2.9905381175763446`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.6766150586043187`, 
         2.8724322839183993`}, {-3.6766150586043187`, 2.883310022013918}}], 
        LineBox[{{-3.6766150586043187`, 
         2.883310022013918}, {-3.6766150586043187`, 2.8940707070540745`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.6271250750319357`, 
         2.7562755599433504`}, {-3.6271250750319357`, 2.7735768687628575`}}], 
        LineBox[{{-3.6271250750319357`, 
         2.7735768687628575`}, {-3.6271250750319357`, 2.7905839260176397`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.577239779380398, 2.666931022778844}, {-3.577239779380398,
          2.675899123478101}}], 
        LineBox[{{-3.577239779380398, 2.675899123478101}, {-3.577239779380398,
          2.6847875116873423`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.5271719803333474`, 
         2.568087090040097}, {-3.5271719803333474`, 2.579512383699999}}], 
        LineBox[{{-3.5271719803333474`, 
         2.579512383699999}, {-3.5271719803333474`, 2.5908086132321415`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.4770227859145613`, 
         2.4471589242341794`}, {-3.4770227859145613`, 2.458037918692001}}], 
        LineBox[{{-3.4770227859145613`, 
         2.458037918692001}, {-3.4770227859145613`, 2.4687998331992516`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.4269594457071775`, 
         2.343637810418284}, {-3.4269594457071775`, 2.3544713359428386`}}], 
        LineBox[{{-3.4269594457071775`, 
         2.3544713359428386`}, {-3.4269594457071775`, 2.365188752933453}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.377049578478242, 2.230134925593643}, {-3.377049578478242,
          2.239516293141006}}], 
        LineBox[{{-3.377049578478242, 2.239516293141006}, {-3.377049578478242,
          2.2488104679845726`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.327422124402821, 2.130625354779844}, {-3.327422124402821,
          2.1418158527757565`}}], 
        LineBox[{{-3.327422124402821, 
         2.1418158527757565`}, {-3.327422124402821, 2.152882508109275}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.2761327623308096`, 
         2.0210228748403845`}, {-3.2761327623308096`, 2.0337376280612185`}}], 
        LineBox[{{-3.2761327623308096`, 
         2.0337376280612185`}, {-3.2761327623308096`, 2.0462927439581367`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.2254264836890396`, 
         1.9117424986494473`}, {-3.2254264836890396`, 1.918834193864078}}], 
        LineBox[{{-3.2254264836890396`, 
         1.918834193864078}, {-3.2254264836890396`, 1.9258759508763845`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.17716826024446, 1.8050218457388927`}, {-3.17716826024446,
          1.8141196372318638`}}], 
        LineBox[{{-3.17716826024446, 1.8141196372318638`}, {-3.17716826024446,
          1.8231354045925807`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.127705210497175, 
         1.6964377581675354`}, {-3.127705210497175, 1.7055270962181834`}}], 
        LineBox[{{-3.127705210497175, 
         1.7055270962181834`}, {-3.127705210497175, 1.7145345618104977`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.077261733718196, 
         1.5854118453788535`}, {-3.077261733718196, 1.5952319343264998`}}], 
        LineBox[{{-3.077261733718196, 
         1.5952319343264998`}, {-3.077261733718196, 1.604956526157422}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.0276924518494375`, 
         1.480392167262926}, {-3.0276924518494375`, 1.4875804564510997`}}], 
        LineBox[{{-3.0276924518494375`, 
         1.4875804564510997`}, {-3.0276924518494375`, 1.4947174426988612`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.977298040136891, 
         1.3770810298261345`}, {-2.977298040136891, 1.3859329991636575`}}], 
        LineBox[{{-2.977298040136891, 
         1.3859329991636575`}, {-2.977298040136891, 1.3947072981726765`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.932588839908245, 1.269810439419048}, {-2.932588839908245,
          1.2789450550144321`}}], 
        LineBox[{{-2.932588839908245, 
         1.2789450550144321`}, {-2.932588839908245, 1.2879969841470453`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.522480231534296, 
         0.3570821791360642}, {-2.522480231534296, 0.4018199704138975}}], 
        LineBox[{{-2.522480231534296, 
         0.4018199704138975}, {-2.522480231534296, 0.4446417059635793}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.380038563220422, 
         0.038524658932424495`}, {-2.380038563220422, 0.07819985171511581}}], 
        LineBox[{{-2.380038563220422, 
         0.07819985171511581}, {-2.380038563220422, 0.11636081008095668`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.2851211182798545`, -0.1865476497388101}, \
{-2.2851211182798545`, -0.1505180065208107}}], 
        LineBox[{{-2.2851211182798545`, -0.1505180065208107}, \
{-2.2851211182798545`, -0.1157414799829208}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.226506167649257, -0.3211716361483736}, \
{-2.226506167649257, -0.28719860671173586`}}], 
        LineBox[{{-2.226506167649257, -0.28719860671173586`}, \
{-2.226506167649257, -0.254341922221198}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.1711381157832257`, -0.4526861214788581}, \
{-2.1711381157832257`, -0.41980744655324337`}}], 
        LineBox[{{-2.1711381157832257`, -0.41980744655324337`}, \
{-2.1711381157832257`, -0.38797545656183047`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.1186760185140363`, -0.5809216281822829}, \
{-2.1186760185140363`, -0.5479457522673019}}], 
        LineBox[{{-2.1186760185140363`, -0.5479457522673019}, \
{-2.1186760185140363`, -0.5160226606115117}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.0688299492905053`, -0.7046949078951291}, \
{-2.0688299492905053`, -0.673758245630414}}], 
        LineBox[{{-2.0688299492905053`, -0.673758245630414}, \
{-2.0688299492905053`, -0.6437500098438078}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.021351319690928, -0.8200721601511878}, \
{-2.021351319690928, -0.7917301280519227}}], 
        LineBox[{{-2.021351319690928, -0.7917301280519227}, \
{-2.021351319690928, -0.7641692773172595}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.976025406568619, -0.9301635446725607}, \
{-1.976025406568619, -0.9027036600587955}}], 
        LineBox[{{-1.976025406568619, -0.9027036600587955}, \
{-1.976025406568619, -0.8759777117849763}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.9326653384575119`, -1.037257867412581}, \
{-1.9326653384575119`, -1.0098900781576479`}}], 
        LineBox[{{-1.9326653384575119`, -1.0098900781576479`}, \
{-1.9326653384575119`, -0.983251375593493}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.8810672419769725`, -1.17153380416838}, \
{-1.8810672419769725`, -1.1416141637443067`}}], 
        LineBox[{{-1.8810672419769725`, -1.1416141637443067`}, \
{-1.8810672419769725`, -1.11256376379841}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.8223707416388202`, -1.3219189810470608`}, \
{-1.8223707416388202`, -1.2926919387763334`}}], 
        LineBox[{{-1.8223707416388202`, -1.2926919387763334`}, \
{-1.8223707416388202`, -1.2642949149265543`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.7758907745205157`, -1.4386030748254146`}, \
{-1.7758907745205157`, -1.4146731201527838`}}], 
        LineBox[{{-1.7758907745205157`, -1.4146731201527838`}, \
{-1.7758907745205157`, -1.3913024506077454`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.7316070609965282`, -1.5584852939076856`}, \
{-1.7316070609965282`, -1.5317320811275723`}}], 
        LineBox[{{-1.7316070609965282`, -1.5317320811275723`}, \
{-1.7316070609965282`, -1.5056759929144334`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.680857774871063, -1.6928643230727762`}, \
{-1.680857774871063, -1.6669413496265966`}}], 
        LineBox[{{-1.680857774871063, -1.6669413496265966`}, \
{-1.680857774871063, -1.6416734315059}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.632560487956873, -1.822102297319412}, \
{-1.632560487956873, -1.796576718985574}}], 
        LineBox[{{-1.632560487956873, -1.796576718985574}, \
{-1.632560487956873, -1.7716865112378122`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.5790774413137347`, -1.9713842665890964`}, \
{-1.5790774413137347`, -1.94475863740435}}], 
        LineBox[{{-1.5790774413137347`, -1.94475863740435}, \
{-1.5790774413137347`, -1.9188235850443318`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.5281875999704038`, -2.110363869112681}, \
{-1.5281875999704038`, -2.0864651302831474`}}], 
        LineBox[{{-1.5281875999704038`, -2.0864651302831474`}, \
{-1.5281875999704038`, -2.0631242353365447`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.4798745637368198`, -2.2502761747563023`}, \
{-1.4798745637368198`, -2.224815111647474}}], 
        LineBox[{{-1.4798745637368198`, -2.224815111647474}, \
{-1.4798745637368198`, -2.1999862510296158`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.4273150021222818`, -2.40224372755166}, \
{-1.4273150021222818`, -2.3777484422840613`}}], 
        LineBox[{{-1.4273150021222818`, -2.3777484422840613`}, \
{-1.4273150021222818`, -2.3538388576964406`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.377381030775886, -2.5462205174792785`}, \
{-1.377381030775886, -2.5229543828125434`}}], 
        LineBox[{{-1.377381030775886, -2.5229543828125434`}, \
{-1.377381030775886, -2.5002172760544723`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.329822772449285, -2.686209433990561}, \
{-1.329822772449285, -2.663506896893459}}], 
        LineBox[{{-1.329822772449285, -2.663506896893459}, \
{-1.329822772449285, -2.641308344422615}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.2789374525299622`, -2.8411602695234515`}, \
{-1.2789374525299622`, -2.8166681206051285`}}], 
        LineBox[{{-1.2789374525299622`, -2.8166681206051285`}, \
{-1.2789374525299622`, -2.7927615241770645`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.2252283792125176`, -3.0073125404148917`}, \
{-1.2252283792125176`, -2.9838642645333464`}}], 
        LineBox[{{-1.2252283792125176`, -2.9838642645333464`}, \
{-1.2252283792125176`, -2.960953236802017}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.1742581157840541`, -3.1637366795773736`}, \
{-1.1742581157840541`, -3.1412100123622957`}}], 
        LineBox[{{-1.1742581157840541`, -3.1412100123622957`}, \
{-1.1742581157840541`, -3.1191796366143913`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.125760810882863, -3.3152863484401958`}, \
{-1.125760810882863, -3.2942324933404725`}}], 
        LineBox[{{-1.125760810882863, -3.2942324933404725`}, \
{-1.125760810882863, -3.2736127784361098`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.0750347908756233`, -3.480484204349799}, \
{-1.0750347908756233`, -3.4582033831068917`}}], 
        LineBox[{{-1.0750347908756233`, -3.4582033831068917`}, \
{-1.0750347908756233`, -3.436408196179977}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.026687762897248, -3.638827878682187}, \
{-1.026687762897248, -3.6183400185583965`}}], 
        LineBox[{{-1.026687762897248, -3.6183400185583965`}, \
{-1.026687762897248, -3.5982634974892544`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.9765855081311018, -3.8027604786997733`}, \
{-0.9765855081311018, -3.7810171105219155`}}], 
        LineBox[{{-0.9765855081311018, -3.7810171105219155`}, \
{-0.9765855081311018, -3.759736472924594}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.924895304705649, -3.9788120944092733`}, \
{-0.924895304705649, -3.958308743860202}}], 
        LineBox[{{-0.924895304705649, -3.958308743860202}, \
{-0.924895304705649, -3.9382173483772096`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.8758086169295246, -4.1440955001409145`}, \
{-0.8758086169295246, -4.1229367463632105`}}], 
        LineBox[{{-0.8758086169295246, -4.1229367463632105`}, \
{-0.8758086169295246, -4.102216424785592}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.8254778772492771, -4.3122438522655955`}, \
{-0.8254778772492771, -4.29302085628333}}], 
        LineBox[{{-0.8254778772492771, -4.29302085628333}, \
{-0.8254778772492771, -4.274160425245053}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.7775597923865766, -4.477103807500962}, \
{-0.7775597923865766, -4.4574398347379915`}}], 
        LineBox[{{-0.7775597923865766, -4.4574398347379915`}, \
{-0.7775597923865766, -4.438155088680047}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.7286714703974044, -4.649129038704672}, \
{-0.7286714703974044, -4.629974743058506}}], 
        LineBox[{{-0.7286714703974044, -4.629974743058506}, \
{-0.7286714703974044, -4.6111804496640945`}}]}},
      Antialiasing->False]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.011000000000000001`], 
    AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwVyXk813ccwHHH7z78bldULKuZErrF99P8WFZyLIxWS6F+pFrHj4RIQmUq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     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.684038170823969, -5.511460439245562},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20000], 9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30000], 10.308952660644293`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40000], 10.596634733096073`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50000], 10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60000], 11.002099841204238`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70000], 11.156250521031495`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80000], 11.289781913656018`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90000], 11.407564949312402`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20000], 9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30000], 10.308952660644293`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40000], 10.596634733096073`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50000], 10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60000], 11.002099841204238`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70000], 11.156250521031495`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80000], 11.289781913656018`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90000], 11.407564949312402`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.684038170823969, -0.7286714703974044}, {-5.511460439245562, 
   6.370281377367599}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.9022983806282463`*^9},
 CellLabel->
  "Out[1189]=",ExpressionUUID->"1add6b8a-36dc-4f43-b566-96b6d8eaf3ab"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C20 - volume - \
Playground\\\\DataMergedBinned.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.9022983819716063`*^9},
 CellLabel->
  "Out[1190]=",ExpressionUUID->"267cd4f2-f9bd-4362-90e5-26ecd66dd2b9"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C20 - volume - \
Playground\\\\Sample playground LH-ESRF-C20 NEW SAXS data merged and \
binned.csv\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.9022983820822225`*^9},
 CellLabel->
  "Out[1192]=",ExpressionUUID->"05b05bcd-482c-4646-9109-3e37316e59e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Plot", " ", "slopes"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotSlopes", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"slope", "[", 
       RowBox[{"datamerged", ",", "0.15"}], "]"}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"default", ":", " ", "0.15"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "False", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<Slopes.pdf\>\""}], "}"}], "]"}], ",", "plotSlopes"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"slope", "[", 
    RowBox[{"datamerged", ",", "0.15"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", " ", "slopes", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", 
      RowBox[{"slope", "[", 
       RowBox[{"datamerged", ",", "0.15"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS slopes.csv\>\""}]}], "\[IndentingNewLine]", "}"}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "exportlist"}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   RowBox[{"NotebookFileName", "[", "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.852797516969694*^9, {3.852797632109549*^9, 3.852797683131383*^9}, {
   3.852797796480151*^9, 3.852797853718195*^9}, {3.8527978838837643`*^9, 
   3.852797901227326*^9}, {3.852797980320817*^9, 3.852798038102087*^9}, 
   3.852798223135673*^9, {3.852798406664549*^9, 3.852798409306513*^9}, {
   3.852798512004775*^9, 3.852798555547234*^9}, {3.85279858828354*^9, 
   3.852798831366269*^9}, {3.852798896028565*^9, 3.852799007753936*^9}, {
   3.852799080350028*^9, 3.852799084748775*^9}, {3.8527992586158037`*^9, 
   3.8527992606884203`*^9}, {3.852801934781908*^9, 3.85280197103442*^9}, {
   3.852802103164875*^9, 3.852802118419861*^9}, {3.852862635200562*^9, 
   3.8528626398081703`*^9}, {3.85286268207966*^9, 3.85286275183375*^9}, {
   3.852862799533414*^9, 3.852862876114451*^9}, {3.8528629338179607`*^9, 
   3.852862985846582*^9}, {3.852863040437448*^9, 3.852863051004711*^9}, {
   3.852868510428824*^9, 3.852868602768145*^9}, {3.852868644287572*^9, 
   3.85286868020261*^9}, {3.852868718724351*^9, 3.85286873785894*^9}, {
   3.852868770378528*^9, 3.8528689132597523`*^9}, {3.852868965432905*^9, 
   3.852868981650947*^9}, 3.852870677134739*^9, {3.8528710993603067`*^9, 
   3.852871145669981*^9}, {3.8528716178560038`*^9, 3.852871618411791*^9}, {
   3.852874052533587*^9, 3.852874070324737*^9}, {3.8533820192129173`*^9, 
   3.853382032526078*^9}, {3.853403584226432*^9, 3.853403584753387*^9}, {
   3.8534051467395353`*^9, 3.853405196243081*^9}, {3.853405235261485*^9, 
   3.8534052353804817`*^9}, {3.853405414194544*^9, 3.85340541704944*^9}, {
   3.854423706814918*^9, 3.854423713174549*^9}, {3.8601401065322495`*^9, 
   3.8601401162752795`*^9}, {3.8617652315248656`*^9, 3.861765245785426*^9}, {
   3.861765486245756*^9, 3.861765500810083*^9}, {3.8617668960181065`*^9, 
   3.861766896503375*^9}, {3.861766959391518*^9, 3.861766970643777*^9}, {
   3.861768170754223*^9, 3.861768171551543*^9}, {3.861768267366991*^9, 
   3.8617682678668547`*^9}, 3.861940907625001*^9, {3.861941874731223*^9, 
   3.8619418752572*^9}, {3.863686273326891*^9, 3.86368627384243*^9}, 
   3.863687238834276*^9, {3.8895154361670246`*^9, 3.889515452084921*^9}, {
   3.889672427830373*^9, 3.8896724458079796`*^9}, {3.8896763888939342`*^9, 
   3.8896765605915513`*^9}, 3.889676629643072*^9, {3.88967679120571*^9, 
   3.88967681543388*^9}, {3.889676858823769*^9, 3.889676888283419*^9}, {
   3.8926137291399455`*^9, 3.8926137292831807`*^9}, 3.902042275559038*^9, {
   3.902042306429104*^9, 3.9020423363791375`*^9}},
 CellLabel->
  "In[1193]:=",ExpressionUUID->"8edd1d77-e6da-4feb-ad70-9ef9a39ee410"],

Cell[BoxData[
 GraphicsBox[{{{
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-5.352012198649872, -2.0093287828709796`}, \
{-5.352012198649872, -1.6814367993293893`}}], 
         LineBox[{{-5.352012198649872, -1.6814367993293893`}, \
{-5.352012198649872, -1.3535448157877992`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-5.197327949963066, -2.162449290062261}, \
{-5.197327949963066, -1.853973646897377}}], 
         LineBox[{{-5.197327949963066, -1.853973646897377}, \
{-5.197327949963066, -1.5454980037324935`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-5.046182498246482, -2.0517235372113287`}, \
{-5.046182498246482, -1.7610744015672055`}}], 
         LineBox[{{-5.046182498246482, -1.7610744015672055`}, \
{-5.046182498246482, -1.4704252659230823`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.894444132978499, -2.0825971397420115`}, \
{-4.894444132978499, -1.7869663217644973`}}], 
         LineBox[{{-4.894444132978499, -1.7869663217644973`}, \
{-4.894444132978499, -1.491335503786983}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.745125399370905, -2.1808530865199893`}, \
{-4.745125399370905, -1.90031225283698}}], 
         LineBox[{{-4.745125399370905, -1.90031225283698}, \
{-4.745125399370905, -1.6197714191539707`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.596628633102665, -2.2183411497318897`}, \
{-4.596628633102665, -1.9599645382822033`}}], 
         LineBox[{{-4.596628633102665, -1.9599645382822033`}, \
{-4.596628633102665, -1.7015879268325167`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.447741719114617, -2.2274008505891785`}, \
{-4.447741719114617, -1.9807057577397864`}}], 
         LineBox[{{-4.447741719114617, -1.9807057577397864`}, \
{-4.447741719114617, -1.7340106648903946`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.298711959937622, -2.185318714234099}, \
{-4.298711959937622, -1.9531048696628939`}}], 
         LineBox[{{-4.298711959937622, -1.9531048696628939`}, \
{-4.298711959937622, -1.7208910250916887`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.149632905511913, -2.219952502474402}, \
{-4.149632905511913, -2.001896117050877}}], 
         LineBox[{{-4.149632905511913, -2.001896117050877}, \
{-4.149632905511913, -1.7838397316273522`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.001278268975371, -2.2274534134911748`}, \
{-4.001278268975371, -2.0285179870113916`}}], 
         LineBox[{{-4.001278268975371, -2.0285179870113916`}, \
{-4.001278268975371, -1.8295825605316085`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.8508575458258987`, -2.4175562263623713`}, \
{-3.8508575458258987`, -2.225690849696841}}], 
         LineBox[{{-3.8508575458258987`, -2.225690849696841}, \
{-3.8508575458258987`, -2.033825473031311}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.6998351226863213`, -2.2727215623528925`}, \
{-3.6998351226863213`, -2.0919678625081652`}}], 
         LineBox[{{-3.6998351226863213`, -2.0919678625081652`}, \
{-3.6998351226863213`, -1.9112141626634382`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.550260154845919, -2.2629091764730767`}, \
{-3.550260154845919, -2.091929028752837}}], 
         LineBox[{{-3.550260154845919, -2.091929028752837}, \
{-3.550260154845919, -1.9209488810325972`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.3997502222704012`, -2.322751107274743}, \
{-3.3997502222704012`, -2.165765529900271}}], 
         LineBox[{{-3.3997502222704012`, -2.165765529900271}, \
{-3.3997502222704012`, -2.008779952525799}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.2492191603155653`, -2.3145014418751098`}, \
{-3.2492191603155653`, -2.1714505004601428`}}], 
         LineBox[{{-3.2492191603155653`, -2.1714505004601428`}, \
{-3.2492191603155653`, -2.0283995590451758`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.099363949694378, -2.2945559205990365`}, \
{-3.099363949694378, -2.1623787439387914`}}], 
         LineBox[{{-3.099363949694378, -2.1623787439387914`}, \
{-3.099363949694378, -2.0302015672785463`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.9723318619592627`, -2.3860474720718177`}, \
{-2.9723318619592627`, -2.1734384762855994`}}], 
         LineBox[{{-2.9723318619592627`, -2.1734384762855994`}, \
{-2.9723318619592627`, -1.960829480499381}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.8161289018458944`, -2.3409563105713964`}, \
{-2.8161289018458944`, -2.03975469148549}}], 
         LineBox[{{-2.8161289018458944`, -2.03975469148549}, \
{-2.8161289018458944`, -1.738553072399584}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.637122953927779, -2.8279016767511895`}, \
{-2.637122953927779, -2.2657338500571558`}}], 
         LineBox[{{-2.637122953927779, -2.2657338500571558`}, \
{-2.637122953927779, -1.703566023363122}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.4883394437723703`, -2.800252316094759}, \
{-2.4883394437723703`, -2.2763007569610387`}}], 
         LineBox[{{-2.4883394437723703`, -2.2763007569610387`}, \
{-2.4883394437723703`, -1.7523491978273182`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.3426491274116255`, -2.859425707168809}, \
{-2.3426491274116255`, -2.3670959616362555`}}], 
         LineBox[{{-2.3426491274116255`, -2.3670959616362555`}, \
{-2.3426491274116255`, -1.8747662161037018`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.1952323671440643`, -2.860830668535795}, \
{-2.1952323671440643`, -2.4037948759029937`}}], 
         LineBox[{{-2.1952323671440643`, -2.4037948759029937`}, \
{-2.1952323671440643`, -1.9467590832701922`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.048114358050804, -2.9272322320171433`}, \
{-2.048114358050804, -2.479718655123771}}], 
         LineBox[{{-2.048114358050804, -2.479718655123771}, \
{-2.048114358050804, -2.0322050782303984`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.9047213128625353`, -2.953375600295039}, \
{-1.9047213128625353`, -2.5367909172167677`}}], 
         LineBox[{{-1.9047213128625353`, -2.5367909172167677`}, \
{-1.9047213128625353`, -2.1202062341384966`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.7572185227137695`, -3.028642298198434}, \
{-1.7572185227137695`, -2.637889192357381}}], 
         LineBox[{{-1.7572185227137695`, -2.637889192357381}, \
{-1.7572185227137695`, -2.247136086516328}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.6053998639759, -3.1266725439928713`}, \
{-1.6053998639759, -2.754243549745302}}], 
         LineBox[{{-1.6053998639759, -2.754243549745302}, {-1.6053998639759, \
-2.3818145554977326`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.4536487775630647`, -3.251344196972014}, \
{-1.4536487775630647`, -2.889392459094982}}], 
         LineBox[{{-1.4536487775630647`, -2.889392459094982}, \
{-1.4536487775630647`, -2.52744072121795}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.3021571254789979`, -3.36788833133832}, \
{-1.3021571254789979`, -3.020276707551879}}], 
         LineBox[{{-1.3021571254789979`, -3.020276707551879}, \
{-1.3021571254789979`, -2.6726650837654375`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.1509597708634107`, -3.5098073498850786`}, \
{-1.1509597708634107`, -3.1684928768164284`}}], 
         LineBox[{{-1.1509597708634107`, -3.1684928768164284`}, \
{-1.1509597708634107`, -2.8271784037477783`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.0007923805337786`, -3.6421170590085596`}, \
{-1.0007923805337786`, -3.3131005732446854`}}], 
         LineBox[{{-1.0007923805337786`, -3.3131005732446854`}, \
{-1.0007923805337786`, -2.984084087480811}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-0.8504177096512346, -3.722831385925379}, \
{-0.8504177096512346, -3.40891501624373}}], 
         LineBox[{{-0.8504177096512346, -3.40891501624373}, \
{-0.8504177096512346, -3.0949986465620807`}}]}},
       Antialiasing->False]}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-5.352012198649872, -1.3535448157877992`}, 
            Offset[{3, 
             0}, {-5.352012198649872, -1.3535448157877992`}]}, \
{{-5.352012198649872, -1.3535448157877992`}, 
            Offset[{-3, 
             0}, {-5.352012198649872, -1.3535448157877992`}]}, \
{{-5.352012198649872, -2.0093287828709796`}, 
            Offset[{3, 
             0}, {-5.352012198649872, -2.0093287828709796`}]}, \
{{-5.352012198649872, -2.0093287828709796`}, 
            Offset[{-3, 
             0}, {-5.352012198649872, -2.0093287828709796`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-5.197327949963066, -1.5454980037324935`}, 
            Offset[{3, 
             0}, {-5.197327949963066, -1.5454980037324935`}]}, \
{{-5.197327949963066, -1.5454980037324935`}, 
            Offset[{-3, 
             0}, {-5.197327949963066, -1.5454980037324935`}]}, \
{{-5.197327949963066, -2.162449290062261}, 
            Offset[{3, 
             0}, {-5.197327949963066, -2.162449290062261}]}, \
{{-5.197327949963066, -2.162449290062261}, 
            Offset[{-3, 0}, {-5.197327949963066, -2.162449290062261}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-5.046182498246482, -1.4704252659230823`}, 
            Offset[{3, 
             0}, {-5.046182498246482, -1.4704252659230823`}]}, \
{{-5.046182498246482, -1.4704252659230823`}, 
            Offset[{-3, 
             0}, {-5.046182498246482, -1.4704252659230823`}]}, \
{{-5.046182498246482, -2.0517235372113287`}, 
            Offset[{3, 
             0}, {-5.046182498246482, -2.0517235372113287`}]}, \
{{-5.046182498246482, -2.0517235372113287`}, 
            Offset[{-3, 
             0}, {-5.046182498246482, -2.0517235372113287`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.894444132978499, -1.491335503786983}, 
            Offset[{3, 
             0}, {-4.894444132978499, -1.491335503786983}]}, \
{{-4.894444132978499, -1.491335503786983}, 
            Offset[{-3, 
             0}, {-4.894444132978499, -1.491335503786983}]}, \
{{-4.894444132978499, -2.0825971397420115`}, 
            Offset[{3, 
             0}, {-4.894444132978499, -2.0825971397420115`}]}, \
{{-4.894444132978499, -2.0825971397420115`}, 
            Offset[{-3, 
             0}, {-4.894444132978499, -2.0825971397420115`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.745125399370905, -1.6197714191539707`}, 
            Offset[{3, 
             0}, {-4.745125399370905, -1.6197714191539707`}]}, \
{{-4.745125399370905, -1.6197714191539707`}, 
            Offset[{-3, 
             0}, {-4.745125399370905, -1.6197714191539707`}]}, \
{{-4.745125399370905, -2.1808530865199893`}, 
            Offset[{3, 
             0}, {-4.745125399370905, -2.1808530865199893`}]}, \
{{-4.745125399370905, -2.1808530865199893`}, 
            Offset[{-3, 
             0}, {-4.745125399370905, -2.1808530865199893`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.596628633102665, -1.7015879268325167`}, 
            Offset[{3, 
             0}, {-4.596628633102665, -1.7015879268325167`}]}, \
{{-4.596628633102665, -1.7015879268325167`}, 
            Offset[{-3, 
             0}, {-4.596628633102665, -1.7015879268325167`}]}, \
{{-4.596628633102665, -2.2183411497318897`}, 
            Offset[{3, 
             0}, {-4.596628633102665, -2.2183411497318897`}]}, \
{{-4.596628633102665, -2.2183411497318897`}, 
            Offset[{-3, 
             0}, {-4.596628633102665, -2.2183411497318897`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.447741719114617, -1.7340106648903946`}, 
            Offset[{3, 
             0}, {-4.447741719114617, -1.7340106648903946`}]}, \
{{-4.447741719114617, -1.7340106648903946`}, 
            Offset[{-3, 
             0}, {-4.447741719114617, -1.7340106648903946`}]}, \
{{-4.447741719114617, -2.2274008505891785`}, 
            Offset[{3, 
             0}, {-4.447741719114617, -2.2274008505891785`}]}, \
{{-4.447741719114617, -2.2274008505891785`}, 
            Offset[{-3, 
             0}, {-4.447741719114617, -2.2274008505891785`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.298711959937622, -1.7208910250916887`}, 
            Offset[{3, 
             0}, {-4.298711959937622, -1.7208910250916887`}]}, \
{{-4.298711959937622, -1.7208910250916887`}, 
            Offset[{-3, 
             0}, {-4.298711959937622, -1.7208910250916887`}]}, \
{{-4.298711959937622, -2.185318714234099}, 
            Offset[{3, 
             0}, {-4.298711959937622, -2.185318714234099}]}, \
{{-4.298711959937622, -2.185318714234099}, 
            Offset[{-3, 0}, {-4.298711959937622, -2.185318714234099}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.149632905511913, -1.7838397316273522`}, 
            Offset[{3, 
             0}, {-4.149632905511913, -1.7838397316273522`}]}, \
{{-4.149632905511913, -1.7838397316273522`}, 
            Offset[{-3, 
             0}, {-4.149632905511913, -1.7838397316273522`}]}, \
{{-4.149632905511913, -2.219952502474402}, 
            Offset[{3, 
             0}, {-4.149632905511913, -2.219952502474402}]}, \
{{-4.149632905511913, -2.219952502474402}, 
            Offset[{-3, 0}, {-4.149632905511913, -2.219952502474402}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.001278268975371, -1.8295825605316085`}, 
            Offset[{3, 
             0}, {-4.001278268975371, -1.8295825605316085`}]}, \
{{-4.001278268975371, -1.8295825605316085`}, 
            Offset[{-3, 
             0}, {-4.001278268975371, -1.8295825605316085`}]}, \
{{-4.001278268975371, -2.2274534134911748`}, 
            Offset[{3, 
             0}, {-4.001278268975371, -2.2274534134911748`}]}, \
{{-4.001278268975371, -2.2274534134911748`}, 
            Offset[{-3, 
             0}, {-4.001278268975371, -2.2274534134911748`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.8508575458258987`, -2.033825473031311}, 
            Offset[{3, 
             0}, {-3.8508575458258987`, -2.033825473031311}]}, \
{{-3.8508575458258987`, -2.033825473031311}, 
            Offset[{-3, 
             0}, {-3.8508575458258987`, -2.033825473031311}]}, \
{{-3.8508575458258987`, -2.4175562263623713`}, 
            Offset[{3, 
             0}, {-3.8508575458258987`, -2.4175562263623713`}]}, \
{{-3.8508575458258987`, -2.4175562263623713`}, 
            Offset[{-3, 
             0}, {-3.8508575458258987`, -2.4175562263623713`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.6998351226863213`, -1.9112141626634382`}, 
            Offset[{3, 
             0}, {-3.6998351226863213`, -1.9112141626634382`}]}, \
{{-3.6998351226863213`, -1.9112141626634382`}, 
            Offset[{-3, 
             0}, {-3.6998351226863213`, -1.9112141626634382`}]}, \
{{-3.6998351226863213`, -2.2727215623528925`}, 
            Offset[{3, 
             0}, {-3.6998351226863213`, -2.2727215623528925`}]}, \
{{-3.6998351226863213`, -2.2727215623528925`}, 
            Offset[{-3, 
             0}, {-3.6998351226863213`, -2.2727215623528925`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.550260154845919, -1.9209488810325972`}, 
            Offset[{3, 
             0}, {-3.550260154845919, -1.9209488810325972`}]}, \
{{-3.550260154845919, -1.9209488810325972`}, 
            Offset[{-3, 
             0}, {-3.550260154845919, -1.9209488810325972`}]}, \
{{-3.550260154845919, -2.2629091764730767`}, 
            Offset[{3, 
             0}, {-3.550260154845919, -2.2629091764730767`}]}, \
{{-3.550260154845919, -2.2629091764730767`}, 
            Offset[{-3, 
             0}, {-3.550260154845919, -2.2629091764730767`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.3997502222704012`, -2.008779952525799}, 
            Offset[{3, 
             0}, {-3.3997502222704012`, -2.008779952525799}]}, \
{{-3.3997502222704012`, -2.008779952525799}, 
            Offset[{-3, 
             0}, {-3.3997502222704012`, -2.008779952525799}]}, \
{{-3.3997502222704012`, -2.322751107274743}, 
            Offset[{3, 
             0}, {-3.3997502222704012`, -2.322751107274743}]}, \
{{-3.3997502222704012`, -2.322751107274743}, 
            Offset[{-3, 
             0}, {-3.3997502222704012`, -2.322751107274743}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.2492191603155653`, -2.0283995590451758`}, 
            Offset[{3, 
             0}, {-3.2492191603155653`, -2.0283995590451758`}]}, \
{{-3.2492191603155653`, -2.0283995590451758`}, 
            Offset[{-3, 
             0}, {-3.2492191603155653`, -2.0283995590451758`}]}, \
{{-3.2492191603155653`, -2.3145014418751098`}, 
            Offset[{3, 
             0}, {-3.2492191603155653`, -2.3145014418751098`}]}, \
{{-3.2492191603155653`, -2.3145014418751098`}, 
            Offset[{-3, 
             0}, {-3.2492191603155653`, -2.3145014418751098`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.099363949694378, -2.0302015672785463`}, 
            Offset[{3, 
             0}, {-3.099363949694378, -2.0302015672785463`}]}, \
{{-3.099363949694378, -2.0302015672785463`}, 
            Offset[{-3, 
             0}, {-3.099363949694378, -2.0302015672785463`}]}, \
{{-3.099363949694378, -2.2945559205990365`}, 
            Offset[{3, 
             0}, {-3.099363949694378, -2.2945559205990365`}]}, \
{{-3.099363949694378, -2.2945559205990365`}, 
            Offset[{-3, 
             0}, {-3.099363949694378, -2.2945559205990365`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.9723318619592627`, -1.960829480499381}, 
            Offset[{3, 
             0}, {-2.9723318619592627`, -1.960829480499381}]}, \
{{-2.9723318619592627`, -1.960829480499381}, 
            Offset[{-3, 
             0}, {-2.9723318619592627`, -1.960829480499381}]}, \
{{-2.9723318619592627`, -2.3860474720718177`}, 
            Offset[{3, 
             0}, {-2.9723318619592627`, -2.3860474720718177`}]}, \
{{-2.9723318619592627`, -2.3860474720718177`}, 
            Offset[{-3, 
             0}, {-2.9723318619592627`, -2.3860474720718177`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.8161289018458944`, -1.738553072399584}, 
            Offset[{3, 
             0}, {-2.8161289018458944`, -1.738553072399584}]}, \
{{-2.8161289018458944`, -1.738553072399584}, 
            Offset[{-3, 
             0}, {-2.8161289018458944`, -1.738553072399584}]}, \
{{-2.8161289018458944`, -2.3409563105713964`}, 
            Offset[{3, 
             0}, {-2.8161289018458944`, -2.3409563105713964`}]}, \
{{-2.8161289018458944`, -2.3409563105713964`}, 
            Offset[{-3, 
             0}, {-2.8161289018458944`, -2.3409563105713964`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.637122953927779, -1.703566023363122}, 
            Offset[{3, 
             0}, {-2.637122953927779, -1.703566023363122}]}, \
{{-2.637122953927779, -1.703566023363122}, 
            Offset[{-3, 
             0}, {-2.637122953927779, -1.703566023363122}]}, \
{{-2.637122953927779, -2.8279016767511895`}, 
            Offset[{3, 
             0}, {-2.637122953927779, -2.8279016767511895`}]}, \
{{-2.637122953927779, -2.8279016767511895`}, 
            Offset[{-3, 
             0}, {-2.637122953927779, -2.8279016767511895`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.4883394437723703`, -1.7523491978273182`}, 
            Offset[{3, 
             0}, {-2.4883394437723703`, -1.7523491978273182`}]}, \
{{-2.4883394437723703`, -1.7523491978273182`}, 
            Offset[{-3, 
             0}, {-2.4883394437723703`, -1.7523491978273182`}]}, \
{{-2.4883394437723703`, -2.800252316094759}, 
            Offset[{3, 
             0}, {-2.4883394437723703`, -2.800252316094759}]}, \
{{-2.4883394437723703`, -2.800252316094759}, 
            Offset[{-3, 
             0}, {-2.4883394437723703`, -2.800252316094759}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.3426491274116255`, -1.8747662161037018`}, 
            Offset[{3, 
             0}, {-2.3426491274116255`, -1.8747662161037018`}]}, \
{{-2.3426491274116255`, -1.8747662161037018`}, 
            Offset[{-3, 
             0}, {-2.3426491274116255`, -1.8747662161037018`}]}, \
{{-2.3426491274116255`, -2.859425707168809}, 
            Offset[{3, 
             0}, {-2.3426491274116255`, -2.859425707168809}]}, \
{{-2.3426491274116255`, -2.859425707168809}, 
            Offset[{-3, 
             0}, {-2.3426491274116255`, -2.859425707168809}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.1952323671440643`, -1.9467590832701922`}, 
            Offset[{3, 
             0}, {-2.1952323671440643`, -1.9467590832701922`}]}, \
{{-2.1952323671440643`, -1.9467590832701922`}, 
            Offset[{-3, 
             0}, {-2.1952323671440643`, -1.9467590832701922`}]}, \
{{-2.1952323671440643`, -2.860830668535795}, 
            Offset[{3, 
             0}, {-2.1952323671440643`, -2.860830668535795}]}, \
{{-2.1952323671440643`, -2.860830668535795}, 
            Offset[{-3, 
             0}, {-2.1952323671440643`, -2.860830668535795}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.048114358050804, -2.0322050782303984`}, 
            Offset[{3, 
             0}, {-2.048114358050804, -2.0322050782303984`}]}, \
{{-2.048114358050804, -2.0322050782303984`}, 
            Offset[{-3, 
             0}, {-2.048114358050804, -2.0322050782303984`}]}, \
{{-2.048114358050804, -2.9272322320171433`}, 
            Offset[{3, 
             0}, {-2.048114358050804, -2.9272322320171433`}]}, \
{{-2.048114358050804, -2.9272322320171433`}, 
            Offset[{-3, 
             0}, {-2.048114358050804, -2.9272322320171433`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.9047213128625353`, -2.1202062341384966`}, 
            Offset[{3, 
             0}, {-1.9047213128625353`, -2.1202062341384966`}]}, \
{{-1.9047213128625353`, -2.1202062341384966`}, 
            Offset[{-3, 
             0}, {-1.9047213128625353`, -2.1202062341384966`}]}, \
{{-1.9047213128625353`, -2.953375600295039}, 
            Offset[{3, 
             0}, {-1.9047213128625353`, -2.953375600295039}]}, \
{{-1.9047213128625353`, -2.953375600295039}, 
            Offset[{-3, 
             0}, {-1.9047213128625353`, -2.953375600295039}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.7572185227137695`, -2.247136086516328}, 
            Offset[{3, 
             0}, {-1.7572185227137695`, -2.247136086516328}]}, \
{{-1.7572185227137695`, -2.247136086516328}, 
            Offset[{-3, 
             0}, {-1.7572185227137695`, -2.247136086516328}]}, \
{{-1.7572185227137695`, -3.028642298198434}, 
            Offset[{3, 
             0}, {-1.7572185227137695`, -3.028642298198434}]}, \
{{-1.7572185227137695`, -3.028642298198434}, 
            Offset[{-3, 
             0}, {-1.7572185227137695`, -3.028642298198434}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.6053998639759, -2.3818145554977326`}, 
            Offset[{3, 
             0}, {-1.6053998639759, -2.3818145554977326`}]}, \
{{-1.6053998639759, -2.3818145554977326`}, 
            Offset[{-3, 
             0}, {-1.6053998639759, -2.3818145554977326`}]}, \
{{-1.6053998639759, -3.1266725439928713`}, 
            Offset[{3, 
             0}, {-1.6053998639759, -3.1266725439928713`}]}, \
{{-1.6053998639759, -3.1266725439928713`}, 
            Offset[{-3, 0}, {-1.6053998639759, -3.1266725439928713`}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.4536487775630647`, -2.52744072121795}, 
            Offset[{3, 
             0}, {-1.4536487775630647`, -2.52744072121795}]}, \
{{-1.4536487775630647`, -2.52744072121795}, 
            Offset[{-3, 
             0}, {-1.4536487775630647`, -2.52744072121795}]}, \
{{-1.4536487775630647`, -3.251344196972014}, 
            Offset[{3, 
             0}, {-1.4536487775630647`, -3.251344196972014}]}, \
{{-1.4536487775630647`, -3.251344196972014}, 
            Offset[{-3, 
             0}, {-1.4536487775630647`, -3.251344196972014}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.3021571254789979`, -2.6726650837654375`}, 
            Offset[{3, 
             0}, {-1.3021571254789979`, -2.6726650837654375`}]}, \
{{-1.3021571254789979`, -2.6726650837654375`}, 
            Offset[{-3, 
             0}, {-1.3021571254789979`, -2.6726650837654375`}]}, \
{{-1.3021571254789979`, -3.36788833133832}, 
            Offset[{3, 
             0}, {-1.3021571254789979`, -3.36788833133832}]}, \
{{-1.3021571254789979`, -3.36788833133832}, 
            Offset[{-3, 0}, {-1.3021571254789979`, -3.36788833133832}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.1509597708634107`, -2.8271784037477783`}, 
            Offset[{3, 
             0}, {-1.1509597708634107`, -2.8271784037477783`}]}, \
{{-1.1509597708634107`, -2.8271784037477783`}, 
            Offset[{-3, 
             0}, {-1.1509597708634107`, -2.8271784037477783`}]}, \
{{-1.1509597708634107`, -3.5098073498850786`}, 
            Offset[{3, 
             0}, {-1.1509597708634107`, -3.5098073498850786`}]}, \
{{-1.1509597708634107`, -3.5098073498850786`}, 
            Offset[{-3, 
             0}, {-1.1509597708634107`, -3.5098073498850786`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.0007923805337786`, -2.984084087480811}, 
            Offset[{3, 
             0}, {-1.0007923805337786`, -2.984084087480811}]}, \
{{-1.0007923805337786`, -2.984084087480811}, 
            Offset[{-3, 
             0}, {-1.0007923805337786`, -2.984084087480811}]}, \
{{-1.0007923805337786`, -3.6421170590085596`}, 
            Offset[{3, 
             0}, {-1.0007923805337786`, -3.6421170590085596`}]}, \
{{-1.0007923805337786`, -3.6421170590085596`}, 
            Offset[{-3, 
             0}, {-1.0007923805337786`, -3.6421170590085596`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-0.8504177096512346, -3.0949986465620807`}, 
            Offset[{3, 
             0}, {-0.8504177096512346, -3.0949986465620807`}]}, \
{{-0.8504177096512346, -3.0949986465620807`}, 
            Offset[{-3, 
             0}, {-0.8504177096512346, -3.0949986465620807`}]}, \
{{-0.8504177096512346, -3.722831385925379}, 
            Offset[{3, 
             0}, {-0.8504177096512346, -3.722831385925379}]}, \
{{-0.8504177096512346, -3.722831385925379}, 
            Offset[{-3, 0}, {-0.8504177096512346, -3.722831385925379}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}}}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAAHvrD4nVoFcD9kfZFKuf6v162jlYQ
yhTAEx9RReCp/b8Cd/52Si8UwNrcCFpcLfy/iPesKemTE8DIgnD/aZf8vy/e
FicC+xLAc/ch0q1n/r/tIcyd8mISwG3ek8YDXP+/wJsiznzKEcBK3EeF+LD/
v7JsS4zhMRHAfsRN5Oo//78GUU5eOZkQwILIhRziAwDAYsctF08BEMBSfmyj
ZzoAwDYEp2aOzg7AlKITATfOAcA7PSQoQ5kNwHULjqVZvADASNfKy+5mDMAw
X2BJRbwAwMbCmT6wMgvAY87N4HxTAcBIvHidZv4JwIjfonAhXwHAv7WSU3/L
CMDnQhY6jUwBwGLKX+1VxwfAJh48tjNjAcDz/PWWbocGwI1XXuhqUQDAsDRV
69MYBcA3fJsROSACwBXLooIe6APAyA/YK901AsAP42HTvr0CwGfF7QHQ7wLA
DgnA/NWPAcCrXdLO+DoDwLJe0seJYgDANU34u3bWA8AE0isOvXn+vwvjUQlZ
SwTAerJvK5Ed/L+oLB2mZRoFwCx4jMS3r/m/CwCb17AIBsBTD3g4JUL3v8n5
KMt5HQfAe/jCtaLV9L9vcp7VhikIwIjr7cpUavK/vUgcyxJZCcA1qAffPgPw
v+eOk986gQrAVoVcM58267+L4Ww8dUULwCKg+PY=
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-6.907755278982122, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {{{
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-6.907755278982137, 0.}, {-6., 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], Automatic}]], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.892613730066387*^9, {3.8926137664245377`*^9, 3.8926137937077703`*^9}, {
   3.8926142852401514`*^9, 3.8926143002994194`*^9}, {3.892614340901927*^9, 
   3.892614358607253*^9}, 3.892614471834504*^9, 3.892696073832374*^9, 
   3.90203711736994*^9, 3.9020422080653267`*^9, 3.9020422780029826`*^9, {
   3.902042309103794*^9, 3.902042338473694*^9}, 3.9022934677601023`*^9, 
   3.902293500826844*^9, 3.902293816575324*^9, 3.9022962202790785`*^9, 
   3.902296689468522*^9, 3.9022975455583563`*^9, 3.9022976074891615`*^9, 
   3.902298382383033*^9},
 CellLabel->
  "Out[1193]=",ExpressionUUID->"65db4c7c-8488-4003-b437-f73ab3c34bb7"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C20 - volume - \
Playground\\\\Slopes.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.892613730066387*^9, {3.8926137664245377`*^9, 3.8926137937077703`*^9}, {
   3.8926142852401514`*^9, 3.8926143002994194`*^9}, {3.892614340901927*^9, 
   3.892614358607253*^9}, 3.892614471834504*^9, 3.892696073832374*^9, 
   3.90203711736994*^9, 3.9020422080653267`*^9, 3.9020422780029826`*^9, {
   3.902042309103794*^9, 3.902042338473694*^9}, 3.9022934677601023`*^9, 
   3.902293500826844*^9, 3.902293816575324*^9, 3.9022962202790785`*^9, 
   3.902296689468522*^9, 3.9022975455583563`*^9, 3.9022976074891615`*^9, 
   3.902298383133863*^9},
 CellLabel->
  "Out[1194]=",ExpressionUUID->"5bec0d2b-28ee-41b9-a672-95d0189e87ba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.004738606382434237`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.68", "0.33"},
       "Around"],
      Around[-1.6814367993293893`, 0.32789198354159016`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.005531324668202713`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.85", "0.31"},
       "Around"],
      Around[-1.853973646897377, 0.3084756431648837]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.006433847850044723`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.76", "0.29"},
       "Around"],
      Around[-1.7610744015672055`, 0.2906491356441232]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.007488070438661962`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.79", "0.30"},
       "Around"],
      Around[-1.7869663217644973`, 0.2956308179775141]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.008693971718852027`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.90", "0.28"},
       "Around"],
      Around[-1.90031225283698, 0.28054083368300936`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.010085781360330545`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.96", "0.26"},
       "Around"],
      Around[-1.9599645382822033`, 0.25837661144968654`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.011704970256750767`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.98", "0.25"},
       "Around"],
      Around[-1.9807057577397864`, 0.24669509284939187`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.013586047120071366`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.95", "0.23"},
       "Around"],
      Around[-1.9531048696628939`, 0.2322138445712051]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.015770204577577458`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.00", "0.22"},
       "Around"],
      Around[-2.001896117050877, 0.21805638542352468`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.018292241533021454`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.03", "0.20"},
       "Around"],
      Around[-2.0285179870113916`, 0.19893542647978318`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.021261495911379928`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.23", "0.19"},
       "Around"],
      Around[-2.225690849696841, 0.19186537666553022`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.02472760315503566`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.09", "0.18"},
       "Around"],
      Around[-2.0919678625081652`, 0.18075369984472708`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.02871716777200143`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.09", "0.17"},
       "Around"],
      Around[-2.091929028752837, 0.17098014772023973`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.03338160690107378`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.17", "0.16"},
       "Around"],
      Around[-2.165765529900271, 0.15698557737447214`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.038804496095529786`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.17", "0.14"},
       "Around"],
      Around[-2.1714505004601428`, 0.1430509414149671]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.04507786506699304`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.16", "0.13"},
       "Around"],
      Around[-2.1623787439387914`, 0.1321771766602449]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.05118381746874888`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.17", "0.21"},
       "Around"],
      Around[-2.1734384762855994`, 0.21260899578621836`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.05983713035005583`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.04", "0.30"},
       "Around"],
      Around[-2.03975469148549, 0.3012016190859062]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.07156687484278981`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.3", "0.6"},
       "Around"],
      Around[-2.2657338500571558`, 0.5621678266940336]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0830477576097193`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.3", "0.5"},
       "Around"],
      Around[-2.2763007569610387`, 0.5239515591337205]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0960727917529942`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.4", "0.5"},
       "Around"],
      Around[-2.3670959616362555`, 0.4923297455325537]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1113326884401501`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.4", "0.5"},
       "Around"],
      Around[-2.4037948759029937`, 0.45703579263280153`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1289778805341014`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.5", "0.4"},
       "Around"],
      Around[-2.479718655123771, 0.44751357689337223`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.148864123358208`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.5", "0.4"},
       "Around"],
      Around[-2.5367909172167677`, 0.4165846830782713]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.17252406884397548`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.6", "0.4"},
       "Around"],
      Around[-2.637889192357381, 0.3907531058410528]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2008092424721844`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.8", "0.4"},
       "Around"],
      Around[-2.754243549745302, 0.37242899424756926`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.23371595287707908`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.9", "0.4"},
       "Around"],
      Around[-2.889392459094982, 0.36195173787703194`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2719445413748963`", ",", 
     InterpretationBox[
      TemplateBox[{"-3.02", "0.35"},
       "Around"],
      Around[-3.020276707551879, 0.3476116237864412]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.316333016423454`", ",", 
     InterpretationBox[
      TemplateBox[{"-3.17", "0.34"},
       "Around"],
      Around[-3.1684928768164284`, 0.34131447306865015`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3675880561226469`", ",", 
     InterpretationBox[
      TemplateBox[{"-3.31", "0.33"},
       "Around"],
      Around[-3.3131005732446854`, 0.32901648576387416`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.42723643388934635`", ",", 
     InterpretationBox[
      TemplateBox[{"-3.41", "0.31"},
       "Around"],
      Around[-3.40891501624373, 0.31391636968164904`]]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.892613730066387*^9, {3.8926137664245377`*^9, 3.8926137937077703`*^9}, {
   3.8926142852401514`*^9, 3.8926143002994194`*^9}, {3.892614340901927*^9, 
   3.892614358607253*^9}, 3.892614471834504*^9, 3.892696073832374*^9, 
   3.90203711736994*^9, 3.9020422080653267`*^9, 3.9020422780029826`*^9, {
   3.902042309103794*^9, 3.902042338473694*^9}, 3.9022934677601023`*^9, 
   3.902293500826844*^9, 3.902293816575324*^9, 3.9022962202790785`*^9, 
   3.902296689468522*^9, 3.9022975455583563`*^9, 3.9022976074891615`*^9, 
   3.902298383172282*^9},
 CellLabel->
  "Out[1195]=",ExpressionUUID->"278a0a7b-f746-4ba0-8f21-ad3a7fa5b996"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C20 - volume - \
Playground\\\\Sample playground LH-ESRF-C20 NEW SAXS slopes.csv\"\>"], \
"Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.892613730066387*^9, {3.8926137664245377`*^9, 3.8926137937077703`*^9}, {
   3.8926142852401514`*^9, 3.8926143002994194`*^9}, {3.892614340901927*^9, 
   3.892614358607253*^9}, 3.892614471834504*^9, 3.892696073832374*^9, 
   3.90203711736994*^9, 3.9020422080653267`*^9, 3.9020422780029826`*^9, {
   3.902042309103794*^9, 3.902042338473694*^9}, 3.9022934677601023`*^9, 
   3.902293500826844*^9, 3.902293816575324*^9, 3.9022962202790785`*^9, 
   3.902296689468522*^9, 3.9022975455583563`*^9, 3.9022976074891615`*^9, 
   3.902298383285738*^9},
 CellLabel->
  "Out[1197]=",ExpressionUUID->"68ac855b-8eb0-46e7-afd6-375844856fab"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C20 - volume - \
Playground\\\\Sample playground LH-ESRF-C20 NEW.nb\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.892613730066387*^9, {3.8926137664245377`*^9, 3.8926137937077703`*^9}, {
   3.8926142852401514`*^9, 3.8926143002994194`*^9}, {3.892614340901927*^9, 
   3.892614358607253*^9}, 3.892614471834504*^9, 3.892696073832374*^9, 
   3.90203711736994*^9, 3.9020422080653267`*^9, 3.9020422780029826`*^9, {
   3.902042309103794*^9, 3.902042338473694*^9}, 3.9022934677601023`*^9, 
   3.902293500826844*^9, 3.902293816575324*^9, 3.9022962202790785`*^9, 
   3.902296689468522*^9, 3.9022975455583563`*^9, 3.9022976074891615`*^9, 
   3.902298383377999*^9},
 CellLabel->
  "Out[1198]=",ExpressionUUID->"c3311436-bc32-4e77-b9a2-da0d95965a2f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fitting slopes using L + R (thickness + radius)", "Subsubsection",
 CellChangeTimes->{{3.8890831159415197`*^9, 3.889083129907494*^9}, {
  3.8895043397252035`*^9, 
  3.889504346042064*^9}},ExpressionUUID->"c264222d-eedd-4632-bf2a-\
25682c9a5ec9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fitSlopeLRResult", "=", 
  RowBox[{"fitSlopeLR", "[", 
   RowBox[{
   "datamerged", ",", " ", "2.6", ",", " ", "0.5", ",", " ", "6", ",", " ", 
    "0.5"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8890831508560247`*^9, 3.889083186178582*^9}, {
  3.889083221328817*^9, 3.889083280853166*^9}, {3.890210231443339*^9, 
  3.8902102343651667`*^9}},
 CellLabel->
  "In[1206]:=",ExpressionUUID->"245caa09-fb84-4947-ab47-dd7c0b5b4707"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9052118255656376`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.3514931430954085`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.9821484033997026`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5048690374768691`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9052118255656376`, " \[Sigma]l = ", 1.3514931430954085`, 
   " \[Mu]r = ", 5.9821484033997026` " \[Sigma]r = ", 0.5048690374768691],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298398870573*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"237fe50b-c5d1-461a-86c3-67f3ed979bd2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.6949683671592322`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.1222416481995097`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.949956089205516`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5267685077762916`"}],
  SequenceForm[
  "\[Mu]l = ", 1.6949683671592322`, " \[Sigma]l = ", 1.1222416481995097`, 
   " \[Mu]r = ", 5.949956089205516 " \[Sigma]r = ", 0.5267685077762916],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298401381547*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"aa05d1c3-37b9-459c-873b-38adaa4f7e90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.6434012596876837`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9953849632707028`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.929691203599062`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5408201948446146`"}],
  SequenceForm[
  "\[Mu]l = ", 1.6434012596876837`, " \[Sigma]l = ", 0.9953849632707028, 
   " \[Mu]r = ", 5.929691203599062 " \[Sigma]r = ", 0.5408201948446146],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.9022984063961*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"2d743b63-e8a9-4506-b6de-6125692357eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.7522002842416176`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8571094120781121`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.888894410984256`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5716857226804426`"}],
  SequenceForm[
  "\[Mu]l = ", 1.7522002842416176`, " \[Sigma]l = ", 0.8571094120781121, 
   " \[Mu]r = ", 5.888894410984256 " \[Sigma]r = ", 0.5716857226804426],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298409242933*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"9921aa35-ca53-47d3-98b8-fb1ec5b1577f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9209067498983954`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7068292986018677`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.83871527280934`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.611322923789187`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9209067498983954`, " \[Sigma]l = ", 0.7068292986018677, 
   " \[Mu]r = ", 5.83871527280934 " \[Sigma]r = ", 0.611322923789187],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.9022984179685955`*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"3a71a70c-2a7c-4c9b-93bd-8a0133644bd1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.8705242524345624`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7789065891847909`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.8330649665788465`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.6190384407328603`"}],
  SequenceForm[
  "\[Mu]l = ", 1.8705242524345624`, " \[Sigma]l = ", 0.7789065891847909, 
   " \[Mu]r = ", 5.8330649665788465` " \[Sigma]r = ", 0.6190384407328603],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298421133526*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"dec7e171-a080-42cc-b28f-0ffb7f6e3f77"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.8915274323545026`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7716577687322826`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.806122913285254`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.644447231650535`"}],
  SequenceForm[
  "\[Mu]l = ", 1.8915274323545026`, " \[Sigma]l = ", 0.7716577687322826, 
   " \[Mu]r = ", 5.806122913285254 " \[Sigma]r = ", 0.644447231650535],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.9022984242875905`*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"e2058ece-e54d-44a6-a6f8-1aae14801aa4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9038922156140854`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7628322246009092`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.7568789787049806`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.6909429154406482`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9038922156140854`, " \[Sigma]l = ", 0.7628322246009092, 
   " \[Mu]r = ", 5.7568789787049806` " \[Sigma]r = ", 0.6909429154406482],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.9022984273371296`*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"105e4598-6c4d-47b6-a3d1-a604baf0c4a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.9010685210538492`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7645967517406014`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.705395147215843`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7387755805177848`"}],
  SequenceForm[
  "\[Mu]l = ", 1.9010685210538492`, " \[Sigma]l = ", 0.7645967517406014, 
   " \[Mu]r = ", 5.705395147215843 " \[Sigma]r = ", 0.7387755805177848],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.9022984303502073`*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"efb9e915-8111-4108-bcee-2efe2d325b68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.8943857178745227`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7679982387338045`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.6669107997590045`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7726145820968418`"}],
  SequenceForm[
  "\[Mu]l = ", 1.8943857178745227`, " \[Sigma]l = ", 0.7679982387338045, 
   " \[Mu]r = ", 5.6669107997590045` " \[Sigma]r = ", 0.7726145820968418],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.9022984334524994`*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"5e6ac1ed-971c-4ea7-a74c-ef96691fbe7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.8930251641145723`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7688988627239453`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.656537360138383`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7808082610808211`"}],
  SequenceForm[
  "\[Mu]l = ", 1.8930251641145723`, " \[Sigma]l = ", 0.7688988627239453, 
   " \[Mu]r = ", 5.656537360138383 " \[Sigma]r = ", 0.7808082610808211],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.9022984359690857`*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"d5ce0316-7cce-47f7-a346-1538d7b47a27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.8930177840779185`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7689463648358039`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.654635173001864`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7821483288060918`"}],
  SequenceForm[
  "\[Mu]l = ", 1.8930177840779185`, " \[Sigma]l = ", 0.7689463648358039, 
   " \[Mu]r = ", 5.654635173001864 " \[Sigma]r = ", 0.7821483288060918],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298439083644*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"3816bc9d-3cde-4c0c-b1c0-d561153bf720"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.8930734612956115`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7689223758818333`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.654380740294827`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7823083087704747`"}],
  SequenceForm[
  "\[Mu]l = ", 1.8930734612956115`, " \[Sigma]l = ", 0.7689223758818333, 
   " \[Mu]r = ", 5.654380740294827 " \[Sigma]r = ", 0.7823083087704747],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298442189639*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"73ccbe86-2465-46fd-a76b-b5bc51b3f862"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.893088258095333`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.768914742326065`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.654374117039351`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7823114430860321`"}],
  SequenceForm[
  "\[Mu]l = ", 1.893088258095333, " \[Sigma]l = ", 0.768914742326065, 
   " \[Mu]r = ", 5.654374117039351 " \[Sigma]r = ", 0.7823114430860321],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.9022984452203712`*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"2f76646f-40d5-4fe3-8ba5-7f110bc072e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.8930892680265157`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7689139745583916`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.654378401871307`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7823088073906261`"}],
  SequenceForm[
  "\[Mu]l = ", 1.8930892680265157`, " \[Sigma]l = ", 0.7689139745583916, 
   " \[Mu]r = ", 5.654378401871307 " \[Sigma]r = ", 0.7823088073906261],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.9022984482506337`*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"b68f0053-0e14-479a-b6a6-e4b221dbb5a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.8930892762653786`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7689140635908197`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.654377860005784`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7823096132882184`"}],
  SequenceForm[
  "\[Mu]l = ", 1.8930892762653786`, " \[Sigma]l = ", 0.7689140635908197, 
   " \[Mu]r = ", 5.654377860005784 " \[Sigma]r = ", 0.7823096132882184],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298457216951*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"e2fc499f-1aed-4509-b1cb-6333ee314522"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.8930892208218155`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.768914121250796`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.65437833315927`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7823091908590085`"}],
  SequenceForm[
  "\[Mu]l = ", 1.8930892208218155`, " \[Sigma]l = ", 0.768914121250796, 
   " \[Mu]r = ", 5.65437833315927 " \[Sigma]r = ", 0.7823091908590085],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298460233699*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"3447cf0e-bc6e-4993-a305-cdf7200b0b30"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.893089280280907`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7689140281052821`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.654378658028005`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7823089063185055`"}],
  SequenceForm[
  "\[Mu]l = ", 1.893089280280907, " \[Sigma]l = ", 0.7689140281052821, 
   " \[Mu]r = ", 5.654378658028005 " \[Sigma]r = ", 0.7823089063185055],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.9022984632728643`*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"dc9dacbc-15fa-4578-bd43-98b80f5b4126"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.8930892840294313`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7689139993411566`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.654378599924018`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7823089272920644`"}],
  SequenceForm[
  "\[Mu]l = ", 1.8930892840294313`, " \[Sigma]l = ", 0.7689139993411566, 
   " \[Mu]r = ", 5.654378599924018 " \[Sigma]r = ", 0.7823089272920644],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8926138193327117`*^9, 3.892614493053379*^9, 3.892696118378016*^9, 
  3.902037136598179*^9, 3.9022935210345845`*^9, 3.902293837473056*^9, 
  3.9022962408910522`*^9, 3.902296707723694*^9, 3.9022975622212825`*^9, 
  3.9022976264842186`*^9, 3.902298475030245*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"94489e95-3bd1-4e6b-a191-e40600185570"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 1206, 53, 17025713724928210084, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9022978287965794`*^9, 3.9022985253178587`*^9},
 CellLabel->
  "During evaluation of \
In[1206]:=",ExpressionUUID->"df7ab9db-02a9-467c-9bad-7b838e27af1e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]l", "\[Rule]", "1.8930892441400011`"}], ",", 
   RowBox[{"\[Sigma]l", "\[Rule]", "0.7689140469568941`"}], ",", 
   RowBox[{"\[Mu]r", "\[Rule]", "5.65437831772787`"}], ",", 
   RowBox[{"\[Sigma]r", "\[Rule]", "0.782309099737639`"}], ",", 
   RowBox[{"\[Mu]lx", "\[Rule]", "8.92363745534991`"}], ",", 
   RowBox[{"\[Sigma]lx", "\[Rule]", "8.012445270844445`"}], ",", 
   RowBox[{"\[Mu]rx", "\[Rule]", "387.7582511896339`"}], ",", 
   RowBox[{"\[Sigma]rx", "\[Rule]", "356.25885765764406`"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8890831915134697`*^9, 3.889083231716405*^9, 
  3.889084522029305*^9, 3.889504478964719*^9, 3.889668839037505*^9, 
  3.8896689977438555`*^9, 3.8902046298151426`*^9, 3.8902062509864902`*^9, 
  3.8902104624878206`*^9, 3.890216989995762*^9, 3.8902173041350584`*^9, 
  3.8902179907784314`*^9, 3.8909820012674875`*^9, 3.8909824058680325`*^9, 
  3.890982955030755*^9, 3.8909840701831517`*^9, 3.8909841450834846`*^9, 
  3.8909843770126934`*^9, 3.8909844264654613`*^9, 3.890984470131813*^9, 
  3.8914172771083*^9, 3.8914183694354115`*^9, 3.891497945190528*^9, 
  3.891498844312603*^9, 3.892613987033495*^9, 3.8926145795212*^9, 
  3.892696438956114*^9, 3.902037238852976*^9, 3.9022936116792793`*^9, 
  3.9022940053921394`*^9, 3.902296351995966*^9, 3.9022968918519087`*^9, 
  3.9022975767506447`*^9, 3.902297828833773*^9, 3.9022985253675375`*^9},
 CellLabel->
  "Out[1206]=",ExpressionUUID->"87bd236a-ff1c-4f04-9022-d4096809a348"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"ColorData", "[", 
    RowBox[{"\"\<SunsetColors\>\"", ",", "\"\<Image\>\""}], "]"}], "*)"}], 
  " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Visualize", " ", "a", " ", "color", " ", "scheme"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"plotIntensityFitPlatelets", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
          "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
          "]"}], "/.", "fitSlopeLRResult"}]}], "}"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{"Optional", ":", " ", 
        RowBox[{
        "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ", 
         "for", " ", "readibility"}], ":", " ", 
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"5", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", 
           RowBox[{"10", "^", "0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "6"}]}], ",", " ", 
           RowBox[{"10", "^", "4"}]}], "}"}]}], "}"}]}], ",", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "third", " ", "color", " ", "not", " ", "currently", " ", "used"}], 
        ",", " ", 
        RowBox[{
        "but", " ", "left", " ", "here", " ", "for", " ", "reference", " ", 
         "as", " ", "it", " ", "has", " ", "a", " ", "pretty", " ", "decent", 
         " ", "contrast", " ", "with", " ", "the", " ", "first", " ", 
         "color"}]}], " ", "*)"}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "9", "]"}], "[", "i", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "datamerged", "]"}]}], "}"}]}], "]"}], 
        ","}], "*)"}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic"}], "}"}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}]}], "]"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"FitToPlot", " ", "=", " ", 
     RowBox[{
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{"\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
       "]"}], "/.", "fitSlopeLRResult"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotIntensityFitPlateletsA", " ", "=", " ", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], "}"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{"Optional", ":", " ", 
         RowBox[{
         "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ",
           "for", " ", "readibility"}], ":", " ", 
         RowBox[{"datamerged", "[", 
          RowBox[{"[", 
           RowBox[{"1", ";;", 
            RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"5", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], ",", " ", 
            RowBox[{"10", "^", "0"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}], ",", " ", 
            RowBox[{"10", "^", "4"}]}], "}"}]}], "}"}]}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"Joined", "\[Rule]", 
        RowBox[{"{", "False", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", " ", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], "}"}]}], ",", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
         "third", " ", "color", " ", "not", " ", "currently", " ", "used"}], 
         ",", " ", 
         RowBox[{
         "but", " ", "left", " ", "here", " ", "for", " ", "reference", " ", 
          "as", " ", "it", " ", "has", " ", "a", " ", "pretty", " ", "decent",
           " ", "contrast", " ", "with", " ", "the", " ", "first", " ", 
          "color"}]}], " ", "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "i", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"Length", "[", "datamerged", "]"}]}], "}"}]}], "]"}], 
         ","}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "Automatic"}], "}"}], ","}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
         "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotIntensityFitPlateletsB", " ", "=", " ", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"FitToPlot", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1000"}], "}"}]}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{"Optional", ":", " ", 
         RowBox[{
         "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ",
           "for", " ", "readibility"}], ":", " ", 
         RowBox[{"datamerged", "[", 
          RowBox[{"[", 
           RowBox[{"1", ";;", 
            RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Joined", "\[Rule]", 
        RowBox[{"{", "True", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}]}], "}"}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"plotIntensityFitPlatelets", " ", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{
     "plotIntensityFitPlateletsA", ",", " ", "plotIntensityFitPlateletsB"}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsIntensityFit.pdf\>\""}], "}"}], "]"}], ",", 
     "plotIntensityFitPlatelets"}], "]"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFit", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"slope", "[", 
         RowBox[{"datamerged", ",", "0.15"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"slope", "[", 
         RowBox[{
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
           "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
           "]"}], "/.", "fitSlopeLRResult"}], "]"}]}], "\[IndentingNewLine]", 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Binned data\>\"", ",", " ", 
         "\"\<Platelets form factor fit\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}], ",", " ", "Dashed"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "\"\<\>\"", ",", "\"\<\>\""}], "}"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFit.pdf\>\""}], "}"}], "]"}], ",", 
     "plotPlateletsFit"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plot3Dprobability", " ", "=", " ", 
    RowBox[{"ListPlot3D", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"l", ",", "r", ",", 
            RowBox[{
             RowBox[{"probfunc", "[", 
              RowBox[{
              "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", 
               ",", "l", ",", "r"}], "]"}], "/.", "fitSlopeLRResult"}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ScalingFunctions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Log\>\"", ",", "\"\<Log\>\"", ",", "None"}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", "Automatic"}], 
        "}"}]}], ",", " ", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Length (nm)\>\"", ",", "\"\<Radius (nm)\>\"", ",", 
         "\"\<Probability\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "12"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"LabelStyle", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
          "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"ColorFunction", "->", 
         RowBox[{"(", 
          RowBox[{"ColorData", "[", "9", "]"}], ")"}]}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"BoxStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsFit3Dprobability.pdf\>\""}], "}"}], "]"}], ",", " ", 
     "plot3Dprobability"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plot2Ddensity", " ", "=", " ", 
    RowBox[{"ListDensityPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"l", ",", "r", ",", 
            RowBox[{
             RowBox[{"probfunc", "[", 
              RowBox[{
              "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", 
               ",", "l", ",", "r"}], "]"}], "/.", "fitSlopeLRResult"}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ScalingFunctions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Log\>\"", ",", "\"\<Log\>\"", ",", "None"}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Length (nm)\>\"", ",", "\"\<Radius (nm)\>\""}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ColorFunction", "->", "\"\<SunsetColors\>\""}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{"\"\<CherryTones\>\"", ",", " ", 
        RowBox[{"\"\<SunsetColors\>\"", " ", 
         RowBox[{"(", 
          RowBox[{"one", " ", "directionally", " ", 
           RowBox[{"continuous", "/", "best"}]}], ")"}]}], ",", " ", 
        "\"\<LightTemperatureMap\>\"", ",", " ", 
        "\"\<ThermometerColors\>\""}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", " ", "Automatic"}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"PlotLegends", "->", " ", 
        RowBox[{"BarLegend", "[", "\"\<SunsetColors\>\"", "]"}]}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "->", "Automatic"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsFit2Ddensity.pdf\>\""}], "}"}], "]"}], ",", 
     "plot2Ddensity"}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plotPlateletDistributions", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lengths", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "/", 
              RowBox[{"Max", "[", "#", "]"}]}], "&"}], "@", 
            RowBox[{"PDF", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"LogNormalDistribution", "[", 
                RowBox[{"\[Mu]l", ",", "\[Sigma]l"}], "]"}], "/.", 
               "fitSlopeLRResult"}], ",", "lengths"}], "]"}]}]}], "}"}], 
         "\[Transpose]"}], ",", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Probability", " ", "normalized", " ", "by", " ", "the", " ", 
          "maximum", " ", "probability"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"radii", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "/", 
              RowBox[{"Max", "[", "#", "]"}]}], "&"}], "@", 
            RowBox[{"PDF", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"LogNormalDistribution", "[", 
                RowBox[{"\[Mu]r", ",", "\[Sigma]r"}], "]"}], "/.", 
               "fitSlopeLRResult"}], ",", "radii"}], "]"}]}]}], "}"}], 
         "\[Transpose]"}]}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Frame", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "->", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Size (nm)\>\"", ",", "\"\<Normalized probability\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Platelets thickness fit distribution\>\"", ",", " ", 
         "\"\<Platelets radii fit distribution\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}], ",", " ", "Dashed"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletFitDistributions.pdf\>\""}], "}"}], "]"}], ",", 
     "plotPlateletDistributions"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.889083294305049*^9, 3.889083315851309*^9}, {
   3.8890833883662243`*^9, 3.8890834456873417`*^9}, {3.889083486103497*^9, 
   3.8890835217014627`*^9}, {3.889083563050894*^9, 3.8890835639046907`*^9}, {
   3.88908424900935*^9, 3.889084266338831*^9}, {3.8895047640723577`*^9, 
   3.8895048132399473`*^9}, {3.889504846884196*^9, 3.8895048547452297`*^9}, {
   3.8895049269182625`*^9, 3.8895050026520877`*^9}, {3.8895050961729617`*^9, 
   3.889505131901743*^9}, {3.8895051665115204`*^9, 3.88950517791572*^9}, {
   3.889514960971097*^9, 3.889515036411804*^9}, {3.8895151686784644`*^9, 
   3.8895152527812395`*^9}, {3.889515322726761*^9, 3.889515322942603*^9}, {
   3.889515414799749*^9, 3.889515415134011*^9}, {3.889515802135846*^9, 
   3.8895158072956295`*^9}, {3.88951762311401*^9, 3.8895176529460897`*^9}, {
   3.8895177805499964`*^9, 3.8895178521346097`*^9}, {3.8895178958654327`*^9, 
   3.889517895992517*^9}, {3.8895179853740325`*^9, 3.8895179941825094`*^9}, {
   3.889518050385213*^9, 3.8895180651462665`*^9}, {3.889518110111107*^9, 
   3.8895181537599416`*^9}, {3.8895181952428894`*^9, 3.889518231543586*^9}, {
   3.8895182640986247`*^9, 3.889518360154647*^9}, {3.889518402957049*^9, 
   3.8895184404208817`*^9}, {3.889518524888457*^9, 3.8895185272255807`*^9}, {
   3.8895889126133003`*^9, 3.889588935610735*^9}, {3.889589038336623*^9, 
   3.889589077704085*^9}, {3.889592078032647*^9, 3.8895920808209195`*^9}, {
   3.889592118364094*^9, 3.8895924083479843`*^9}, {3.8895925522801237`*^9, 
   3.8895925725829153`*^9}, {3.8895927385856147`*^9, 3.889592740371332*^9}, {
   3.8895928489211516`*^9, 3.8895928588784356`*^9}, {3.8895928981345015`*^9, 
   3.889592939760598*^9}, {3.889592994486616*^9, 3.889593006731392*^9}, {
   3.8896690677438173`*^9, 3.8896690861177497`*^9}, {3.8896691662237344`*^9, 
   3.8896691680709915`*^9}, {3.8896692820528316`*^9, 
   3.8896693106620665`*^9}, {3.889669383022016*^9, 3.8896694349828773`*^9}, {
   3.8896699958407335`*^9, 3.8896699966198225`*^9}, {3.8896701115288887`*^9, 
   3.8896701256913085`*^9}, {3.8896701570270524`*^9, 3.889670157394929*^9}, {
   3.8896712449546976`*^9, 3.889671273339734*^9}, {3.8896722465178547`*^9, 
   3.8896723216246796`*^9}, {3.889677150823584*^9, 3.889677160683831*^9}, {
   3.8896771908757315`*^9, 3.889677195202493*^9}, 3.8896773421424313`*^9, {
   3.889677378283571*^9, 3.8896773887669315`*^9}, {3.88967742719445*^9, 
   3.889677430963851*^9}, {3.889677480339917*^9, 3.889677480743126*^9}, {
   3.889677596624218*^9, 3.8896775968970366`*^9}, {3.889680706734044*^9, 
   3.8896807216712313`*^9}, {3.889680801340059*^9, 3.8896808079046683`*^9}, 
   3.8896849744898243`*^9, {3.889685151140499*^9, 3.8896851850751715`*^9}, 
   3.903585415068856*^9, {3.905229784779354*^9, 
   3.9052297922703285`*^9}},ExpressionUUID->"53db37f2-ab19-4a4d-8175-\
4749ca30cef4"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, {}, 
     {GrayLevel[0], PointSize[0.04], Thickness[0.004], LineBox[CompressedData["
1:eJwtlHs8lGkDhsc4M8MwY47OTE7poGTZskpa1qFBRaY1pdO3UUTnTWE7rlot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       "]]}}, {
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.01], Thickness[0.005], PointBox[CompressedData["
1:eJwVl2c41m8bx2/jdu9tVKhIGdlaQr+LEBokSclKKhJCGlRIQ6XMjMiqtISs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       "]]}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.298317366548025, -13.815510557964243`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500000], -13.122363377404328`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 3]], -12.716898269296165`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250000], -12.429216196844383`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200000], -12.206072645530174`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500000, 3]], -12.02375108873622], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 7]], -11.86960040890896], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125000], -11.736069016284437`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 9]], -11.618285980628055`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50000], -10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 3]], -10.41431317630212], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25000], -10.126631103850338`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20000], -9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50000, 3]], -9.721165995742174], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 7]], -9.567015315914915], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[12500], -9.433483923290392], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 9]], -9.315700887634009], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5000], -8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 3]], -8.111728083308073], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2500], -7.824046010856292], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2000], -7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5000, 3]], -7.418580902748128], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 7]], -7.264430222920869], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1250], -7.1308988302963465`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 9]], -7.013115794639964], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500000], -13.122363377404328`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 3]], -12.716898269296165`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250000], -12.429216196844383`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200000], -12.206072645530174`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500000, 3]], -12.02375108873622], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 7]], -11.86960040890896], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125000], -11.736069016284437`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 9]], -11.618285980628055`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50000], -10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 3]], -10.41431317630212], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25000], -10.126631103850338`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20000], -9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50000, 3]], -9.721165995742174], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 7]], -9.567015315914915], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[12500], -9.433483923290392], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 9]], -9.315700887634009], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5000], -8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 3]], -8.111728083308073], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2500], -7.824046010856292], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2000], -7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5000, 3]], -7.418580902748128], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 7]], -7.264430222920869], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1250], -7.1308988302963465`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 9]], -7.013115794639964], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.298317366548036, 0.}, {-13.815510557964274`, 
   4.605170185988092}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8914979473215375`*^9, 
   3.891498845326952*^9, 3.892613988498149*^9, 3.892614580245516*^9, 
   3.8926964425407314`*^9, 3.9020372399058423`*^9, 3.902042373028578*^9, 
   3.9022936127325225`*^9, 3.9022940061294537`*^9, 3.9022963528434954`*^9, 
   3.9022968926411867`*^9, 3.9022978297889404`*^9, 3.9022985261842117`*^9},
 CellLabel->
  "Out[1207]=",ExpressionUUID->"c87ea592-f211-4b77-b028-d4f0cafc773d"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C20 - volume - \
Playground\\\\PlateletsIntensityFit.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8914979473215375`*^9, 
   3.891498845326952*^9, 3.892613988498149*^9, 3.892614580245516*^9, 
   3.8926964425407314`*^9, 3.9020372399058423`*^9, 3.902042373028578*^9, 
   3.9022936127325225`*^9, 3.9022940061294537`*^9, 3.9022963528434954`*^9, 
   3.9022968926411867`*^9, 3.9022978297889404`*^9, 3.9022985277429895`*^9},
 CellLabel->
  "Out[1208]=",ExpressionUUID->"69b08bfe-db7d-40e1-a3fb-1603ea250049"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -2.0093287828709796`}, \
{-5.352012198649872, -1.6814367993293893`}}], 
          
          LineBox[{{-5.352012198649872, -1.6814367993293893`}, \
{-5.352012198649872, -1.3535448157877992`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -2.162449290062261}, \
{-5.197327949963066, -1.853973646897377}}], 
          
          LineBox[{{-5.197327949963066, -1.853973646897377}, \
{-5.197327949963066, -1.5454980037324935`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -2.0517235372113287`}, \
{-5.046182498246482, -1.7610744015672055`}}], 
          
          LineBox[{{-5.046182498246482, -1.7610744015672055`}, \
{-5.046182498246482, -1.4704252659230823`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.0825971397420115`}, \
{-4.894444132978499, -1.7869663217644973`}}], 
          
          LineBox[{{-4.894444132978499, -1.7869663217644973`}, \
{-4.894444132978499, -1.491335503786983}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.1808530865199893`}, \
{-4.745125399370905, -1.90031225283698}}], 
          
          LineBox[{{-4.745125399370905, -1.90031225283698}, \
{-4.745125399370905, -1.6197714191539707`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.2183411497318897`}, \
{-4.596628633102665, -1.9599645382822033`}}], 
          
          LineBox[{{-4.596628633102665, -1.9599645382822033`}, \
{-4.596628633102665, -1.7015879268325167`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.2274008505891785`}, \
{-4.447741719114617, -1.9807057577397864`}}], 
          
          LineBox[{{-4.447741719114617, -1.9807057577397864`}, \
{-4.447741719114617, -1.7340106648903946`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.185318714234099}, \
{-4.298711959937622, -1.9531048696628939`}}], 
          
          LineBox[{{-4.298711959937622, -1.9531048696628939`}, \
{-4.298711959937622, -1.7208910250916887`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.219952502474402}, \
{-4.149632905511913, -2.001896117050877}}], 
          
          LineBox[{{-4.149632905511913, -2.001896117050877}, \
{-4.149632905511913, -1.7838397316273522`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.2274534134911748`}, \
{-4.001278268975371, -2.0285179870113916`}}], 
          
          LineBox[{{-4.001278268975371, -2.0285179870113916`}, \
{-4.001278268975371, -1.8295825605316085`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.4175562263623713`}, \
{-3.8508575458258987`, -2.225690849696841}}], 
          
          LineBox[{{-3.8508575458258987`, -2.225690849696841}, \
{-3.8508575458258987`, -2.033825473031311}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.2727215623528925`}, \
{-3.6998351226863213`, -2.0919678625081652`}}], 
          
          LineBox[{{-3.6998351226863213`, -2.0919678625081652`}, \
{-3.6998351226863213`, -1.9112141626634382`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.2629091764730767`}, \
{-3.550260154845919, -2.091929028752837}}], 
          
          LineBox[{{-3.550260154845919, -2.091929028752837}, \
{-3.550260154845919, -1.9209488810325972`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.322751107274743}, \
{-3.3997502222704012`, -2.165765529900271}}], 
          
          LineBox[{{-3.3997502222704012`, -2.165765529900271}, \
{-3.3997502222704012`, -2.008779952525799}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.3145014418751098`}, \
{-3.2492191603155653`, -2.1714505004601428`}}], 
          
          LineBox[{{-3.2492191603155653`, -2.1714505004601428`}, \
{-3.2492191603155653`, -2.0283995590451758`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.2945559205990365`}, \
{-3.099363949694378, -2.1623787439387914`}}], 
          
          LineBox[{{-3.099363949694378, -2.1623787439387914`}, \
{-3.099363949694378, -2.0302015672785463`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.3860474720718177`}, \
{-2.9723318619592627`, -2.1734384762855994`}}], 
          
          LineBox[{{-2.9723318619592627`, -2.1734384762855994`}, \
{-2.9723318619592627`, -1.960829480499381}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.3409563105713964`}, \
{-2.8161289018458944`, -2.03975469148549}}], 
          
          LineBox[{{-2.8161289018458944`, -2.03975469148549}, \
{-2.8161289018458944`, -1.738553072399584}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.8279016767511895`}, \
{-2.637122953927779, -2.2657338500571558`}}], 
          
          LineBox[{{-2.637122953927779, -2.2657338500571558`}, \
{-2.637122953927779, -1.703566023363122}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.800252316094759}, \
{-2.4883394437723703`, -2.2763007569610387`}}], 
          
          LineBox[{{-2.4883394437723703`, -2.2763007569610387`}, \
{-2.4883394437723703`, -1.7523491978273182`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.859425707168809}, \
{-2.3426491274116255`, -2.3670959616362555`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.3670959616362555`}, \
{-2.3426491274116255`, -1.8747662161037018`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.860830668535795}, \
{-2.1952323671440643`, -2.4037948759029937`}}], 
          
          LineBox[{{-2.1952323671440643`, -2.4037948759029937`}, \
{-2.1952323671440643`, -1.9467590832701922`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.9272322320171433`}, \
{-2.048114358050804, -2.479718655123771}}], 
          
          LineBox[{{-2.048114358050804, -2.479718655123771}, \
{-2.048114358050804, -2.0322050782303984`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -2.953375600295039}, \
{-1.9047213128625353`, -2.5367909172167677`}}], 
          
          LineBox[{{-1.9047213128625353`, -2.5367909172167677`}, \
{-1.9047213128625353`, -2.1202062341384966`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -3.028642298198434}, \
{-1.7572185227137695`, -2.637889192357381}}], 
          
          LineBox[{{-1.7572185227137695`, -2.637889192357381}, \
{-1.7572185227137695`, -2.247136086516328}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -3.1266725439928713`}, \
{-1.6053998639759, -2.754243549745302}}], 
          
          LineBox[{{-1.6053998639759, -2.754243549745302}, {-1.6053998639759, \
-2.3818145554977326`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.251344196972014}, \
{-1.4536487775630647`, -2.889392459094982}}], 
          
          LineBox[{{-1.4536487775630647`, -2.889392459094982}, \
{-1.4536487775630647`, -2.52744072121795}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.36788833133832}, \
{-1.3021571254789979`, -3.020276707551879}}], 
          
          LineBox[{{-1.3021571254789979`, -3.020276707551879}, \
{-1.3021571254789979`, -2.6726650837654375`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.5098073498850786`}, \
{-1.1509597708634107`, -3.1684928768164284`}}], 
          
          LineBox[{{-1.1509597708634107`, -3.1684928768164284`}, \
{-1.1509597708634107`, -2.8271784037477783`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0007923805337786`, -3.6421170590085596`}, \
{-1.0007923805337786`, -3.3131005732446854`}}], 
          
          LineBox[{{-1.0007923805337786`, -3.3131005732446854`}, \
{-1.0007923805337786`, -2.984084087480811}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-0.8504177096512346, -3.722831385925379}, \
{-0.8504177096512346, -3.40891501624373}}], 
          
          LineBox[{{-0.8504177096512346, -3.40891501624373}, \
{-0.8504177096512346, -3.0949986465620807`}}]}}}}}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1lXk8VV0Xx4/pGi/HeLkkhEilhyTC0aBBEyFClDyhRPGIZCxJKKVUSjKl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         "]]}}, {{
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
         PointSize[0.01], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{
               EdgeForm[], 
               DiskBox[{0, 0}]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 AbsoluteThickness[1.6], 
                 RGBColor[
                 0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
                 PointSize[0.01], 
                 Thickness[0.005]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Offset[6.272]], CompressedData["
1:eJwBBQL6/SFib1JlAwAAAB8AAAABAAAAAgAAAB76w+J1aBXA/ZH2RSrn+r9e
to5WEMoUwBMfUUXgqf2/Anf+dkovFMDa3AhaXC38v4j3rCnpkxPAyIJw/2mX
/L8v3hYnAvsSwHP3IdKtZ/6/7SHMnfJiEsBt3pPGA1z/v8CbIs58yhHAStxH
hfiw/7+ybEuM4TERwH7ETeTqP/+/BlFOXjmZEMCCyIUc4gMAwGLHLRdPARDA
Un5so2c6AMA2BKdmjs4OwJSiEwE3zgHAOz0kKEOZDcB1C46lWbwAwEjXysvu
ZgzAMF9gSUW8AMDGwpk+sDILwGPOzeB8UwHASLx4nWb+CcCI36JwIV8BwL+1
klN/ywjA50IWOo1MAcBiyl/tVccHwCYePLYzYwHA8/z1lm6HBsCNV17oalEA
wLA0VevTGAXAN3ybETkgAsAVy6KCHugDwMgP2CvdNQLAD+Nh0769AsBnxe0B
0O8CwA4JwPzVjwHAq13Szvg6A8CyXtLHiWIAwDVN+Lt21gPABNIrDr15/r8L
41EJWUsEwHqybyuRHfy/qCwdpmUaBcAseIzEt6/5vwsAm9ewCAbAUw94OCVC
97/J+SjLeR0HwHv4wrWi1fS/b3Ke1YYpCMCI6+3KVGryv71IHMsSWQnANagH
3z4D8L/njpPfOoEKwFaFXDOfNuu/i+FsPHVFC8AtxPj4
         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         TagBox[
          InsetBox["", {0., 0.}], "InsetString"], CompressedData["
1:eJw1lXk4ldsXx99jOGZe4+GQECKVLqkIrwYNKlFEiJKblKhckYwlCSUyk4RU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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-7.2705523451534315`, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
